"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformManagementSection = exports.TransformManagement = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reauthorization_utils = require("../../common/reauthorization_utils");
var _constants = require("../../../../common/constants");
var _common = require("../../common");
var _use_documentation_links = require("../../hooks/use_documentation_links");
var _hooks = require("../../hooks");
var _navigation = require("../../common/navigation");
var _authorization = require("../../lib/authorization");
var _navigation2 = require("../../services/navigation");
var _use_refresh_interval = require("./components/transform_list/use_refresh_interval");
var _search_selection = require("./components/search_selection");
var _transform_list = require("./components/transform_list");
var _transforms_stats_bar = require("./components/transform_list/transforms_stats_bar");
var _transform_alerting_flyout = require("../../../alerting/transform_alerting_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TransformManagement = () => {
  const {
    esTransform
  } = (0, _use_documentation_links.useDocumentationLinks)();
  const [transformsLoading, setTransformsLoading] = (0, _react.useState)(false);
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const [blockRefresh, setBlockRefresh] = (0, _react.useState)(false);
  const [transforms, setTransforms] = (0, _react.useState)([]);
  const [transformNodes, setTransformNodes] = (0, _react.useState)(0);
  const [errorMessage, setErrorMessage] = (0, _react.useState)(undefined);
  const [transformIdsWithoutConfig, setTransformIdsWithoutConfig] = (0, _react.useState)();
  const deleteTransforms = (0, _hooks.useDeleteTransforms)();
  const getTransforms = (0, _hooks.useGetTransforms)(setTransforms, setTransformNodes, setErrorMessage, setTransformIdsWithoutConfig, setIsInitialized, blockRefresh);

  // Subscribe to the refresh observable to trigger reloading the transform list.
  (0, _common.useRefreshTransformList)({
    isLoading: setTransformsLoading,
    onRefresh: () => getTransforms(true)
  });
  // Call useRefreshInterval() after the subscription above is set up.
  (0, _use_refresh_interval.useRefreshInterval)(setBlockRefresh);
  const {
    canStartStopTransform
  } = (0, _react.useContext)(_authorization.AuthorizationContext).capabilities;
  const unauthorizedTransformsWarning = (0, _react.useMemo)(() => {
    const unauthorizedCnt = transforms.filter(t => (0, _reauthorization_utils.needsReauthorization)(t)).length;
    if (!unauthorizedCnt) return null;
    const insufficientPermissionsMsg = _i18n.i18n.translate('xpack.transform.transformList.unauthorizedTransformsCallout.insufficientPermissionsMsg', {
      defaultMessage: '{unauthorizedCnt, plural, one {A transform was created with insufficient permissions.} other {# transforms were created with insufficient permissions.}}',
      values: {
        unauthorizedCnt
      }
    });
    const actionMsg = canStartStopTransform ? _i18n.i18n.translate('xpack.transform.transformList.unauthorizedTransformsCallout.reauthorizeMsg', {
      defaultMessage: 'Reauthorize to start {unauthorizedCnt, plural, one {transform} other {# transforms}}.',
      values: {
        unauthorizedCnt
      }
    }) : _i18n.i18n.translate('xpack.transform.transformList.unauthorizedTransformsCallout.contactAdminMsg', {
      defaultMessage: 'Contact your administrator to request the required permissions.'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "alert",
      color: "warning",
      title: `${insufficientPermissionsMsg} ${actionMsg}`
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }, [transforms, canStartStopTransform]);
  const [isSearchSelectionVisible, setIsSearchSelectionVisible] = (0, _react.useState)(false);
  const [savedObjectId, setSavedObjectId] = (0, _react.useState)(null);
  if (savedObjectId !== null) {
    return /*#__PURE__*/_react.default.createElement(_navigation.RedirectToCreateTransform, {
      savedObjectId: savedObjectId
    });
  }
  const onCloseModal = () => setIsSearchSelectionVisible(false);
  const onOpenModal = () => setIsSearchSelectionVisible(true);
  const onSearchSelected = (id, type) => {
    setSavedObjectId(id);
  };
  const docsLink = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: esTransform,
    target: "_blank",
    iconType: "help",
    "data-test-subj": "documentationLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.transformList.transformDocsLinkText",
    defaultMessage: "Transform docs"
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "transformAppTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformList.transformTitle",
      defaultMessage: "Transforms"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformList.transformDescription",
      defaultMessage: "Use transforms to pivot existing Elasticsearch indices into summarized entity-centric indices or to create an indexed view of the latest documents for fast access."
    }),
    rightSideItems: [docsLink],
    bottomBorder: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageContentBody_Deprecated, {
    "data-test-subj": "transformPageTransformList"
  }, !isInitialized && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
    lines: 2
  }), isInitialized && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, unauthorizedTransformsWarning, /*#__PURE__*/_react.default.createElement(_transforms_stats_bar.TransformStatsBar, {
    transformNodes: transformNodes,
    transformsList: transforms
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), typeof errorMessage !== 'undefined' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
    verticalPosition: "center",
    horizontalPosition: "center",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.list.errorPromptTitle",
      defaultMessage: "An error occurred getting the transform list"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("pre", null, JSON.stringify(errorMessage))),
    actions: []
  })))), typeof errorMessage === 'undefined' && /*#__PURE__*/_react.default.createElement(_transform_alerting_flyout.AlertRulesManageContext.Provider, {
    value: (0, _transform_alerting_flyout.getAlertRuleManageContext)()
  }, transformIdsWithoutConfig ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.danglingTasksError",
    defaultMessage: "{count} {count, plural, one {transform is} other {transforms are}} missing configuration details: [{transformIds}] {count, plural, one {It} other {They}} cannot be recovered and should be deleted.",
    values: {
      count: transformIdsWithoutConfig.length,
      transformIds: transformIdsWithoutConfig.join(', ')
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    size: "s",
    onClick: async () => {
      await deleteTransforms(
      // If transform task doesn't have any corresponding config
      // we won't know what the destination index or data view would be
      // and should be force deleted
      {
        transformsInfo: transformIdsWithoutConfig.map(id => ({
          id,
          state: _constants.TRANSFORM_STATE.FAILED
        })),
        deleteDestIndex: false,
        deleteDestDataView: false,
        forceDelete: true
      });
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.forceDeleteTransformMessage",
    defaultMessage: "Delete {count} {count, plural, one {transform} other {transforms}}",
    values: {
      count: transformIdsWithoutConfig.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_transform_list.TransformList, {
    onCreateTransform: onOpenModal,
    transformNodes: transformNodes,
    transforms: transforms,
    transformsLoading: transformsLoading
  }), /*#__PURE__*/_react.default.createElement(_transform_alerting_flyout.TransformAlertFlyoutWrapper, null)))), isSearchSelectionVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onCloseModal,
    className: "transformCreateTransformSearchDialog",
    "data-test-subj": "transformSelectSourceModal"
  }, /*#__PURE__*/_react.default.createElement(_search_selection.SearchSelection, {
    onSearchSelected: onSearchSelected
  })));
};
exports.TransformManagement = TransformManagement;
const TransformManagementSection = () => {
  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation2.breadcrumbService.setBreadcrumbs(_navigation2.BREADCRUMB_SECTION.HOME);
    _navigation2.docTitleService.setTitle('home');
  }, []);
  return /*#__PURE__*/_react.default.createElement(_authorization.PrivilegesWrapper, {
    privileges: _constants.APP_GET_TRANSFORM_CLUSTER_PRIVILEGES
  }, /*#__PURE__*/_react.default.createElement(TransformManagement, null));
};
exports.TransformManagementSection = TransformManagementSection;