"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTableSettings = useTableSettings;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZE = 10;
const PAGE_SIZE_OPTIONS = [10, 25, 50];

// Copying from EUI EuiBasicTable types as type is not correctly picked up for table's onChange
// Can be removed when https://github.com/elastic/eui/issues/4011 is addressed in EUI

function useTableSettings(sortByField, items) {
  const [tableSettings, setTableSettings] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: PAGE_SIZE,
    totalItemCount: 0,
    showPerPageOptions: true,
    sortField: sortByField,
    sortDirection: 'asc'
  });
  const onTableChange = ({
    page = {
      index: 0,
      size: PAGE_SIZE
    },
    sort = {
      field: sortByField,
      direction: 'asc'
    }
  }) => {
    const {
      index,
      size
    } = page;
    const {
      field,
      direction
    } = sort;
    setTableSettings({
      ...tableSettings,
      pageIndex: index,
      pageSize: size,
      sortField: field,
      sortDirection: direction
    });
  };
  const {
    pageIndex,
    pageSize,
    sortField,
    sortDirection
  } = tableSettings;
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount: items.length,
    pageSizeOptions: PAGE_SIZE_OPTIONS
  };
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  return {
    onTableChange,
    pagination,
    sorting
  };
}