"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformStatsBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _use_documentation_links = require("../../../../hooks/use_documentation_links");
var _stats_bar = require("../stats_bar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTranformStats(transformNodes, transformsList) {
  const transformStats = {
    total: {
      label: _i18n.i18n.translate('xpack.transform.statsBar.totalTransformsLabel', {
        defaultMessage: 'Total transforms'
      }),
      value: 0,
      show: true
    },
    batch: {
      label: _i18n.i18n.translate('xpack.transform.statsBar.batchTransformsLabel', {
        defaultMessage: 'Batch'
      }),
      value: 0,
      show: true
    },
    continuous: {
      label: _i18n.i18n.translate('xpack.transform.statsBar.continuousTransformsLabel', {
        defaultMessage: 'Continuous'
      }),
      value: 0,
      show: true
    },
    failed: {
      label: _i18n.i18n.translate('xpack.transform.statsBar.failedTransformsLabel', {
        defaultMessage: 'Failed'
      }),
      value: 0,
      show: false
    },
    started: {
      label: _i18n.i18n.translate('xpack.transform.statsBar.startedTransformsLabel', {
        defaultMessage: 'Started'
      }),
      value: 0,
      show: true
    },
    nodes: {
      label: _i18n.i18n.translate('xpack.transform.statsBar.transformNodesLabel', {
        defaultMessage: 'Nodes'
      }),
      value: transformNodes,
      show: true
    }
  };
  if (transformsList === undefined) {
    return transformStats;
  }
  let failedTransforms = 0;
  let startedTransforms = 0;
  transformsList.forEach(transform => {
    if (transform.mode === _constants.TRANSFORM_MODE.CONTINUOUS) {
      transformStats.continuous.value++;
    } else if (transform.mode === _constants.TRANSFORM_MODE.BATCH) {
      transformStats.batch.value++;
    }
    if (transform.stats.state === _constants.TRANSFORM_STATE.FAILED) {
      failedTransforms++;
    } else if (transform.stats.state === _constants.TRANSFORM_STATE.STARTED) {
      startedTransforms++;
    }
  });
  transformStats.total.value = transformsList.length;
  transformStats.started.value = startedTransforms;
  if (failedTransforms !== 0) {
    transformStats.failed.value = failedTransforms;
    transformStats.failed.show = true;
  } else {
    transformStats.failed.show = false;
  }
  return transformStats;
}
const TransformStatsBar = ({
  transformNodes,
  transformsList
}) => {
  const {
    esNodeRoles
  } = (0, _use_documentation_links.useDocumentationLinks)();
  const transformStats = createTranformStats(transformNodes, transformsList);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_stats_bar.StatsBar, {
    stats: transformStats,
    dataTestSub: 'transformStatsBar'
  }), transformNodes === 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformNodes.noTransformNodesCallOutTitle",
      defaultMessage: "There are no transform nodes available."
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.transformNodes.noTransformNodesCallOutBody",
    defaultMessage: "You will not be able to create or run transforms. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: esNodeRoles,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.transform.transformNodes.noTransformNodesLearnMoreLinkText",
        defaultMessage: "Learn more"
      }))
    }
  })))));
};
exports.TransformStatsBar = TransformStatsBar;