"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformHealthColoredDot = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TransformHealthColoredDot = ({
  healthStatus,
  compact = true,
  showToolTip = true
}) => {
  const transformHealthDescription = _constants.TRANSFORM_HEALTH_DESCRIPTION[healthStatus];
  const transformHealthColor = _constants.TRANSFORM_HEALTH_COLOR[healthStatus];
  const transformHealthLabel = _constants.TRANSFORM_HEALTH_LABEL[healthStatus];
  const health = /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: transformHealthColor,
    textSize: compact ? 'xs' : undefined,
    "data-test-subj": "transformListHealth"
  }, transformHealthLabel, compact ? '' : `: ${transformHealthDescription}`);
  if (showToolTip) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: transformHealthDescription
    }, health);
  }
  return health;
};
exports.TransformHealthColoredDot = TransformHealthColoredDot;