"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRowPreviewPane = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _app_dependencies = require("../../../../app_dependencies");
var _common = require("../../../../common");
var _use_transform_config_data = require("../../../../hooks/use_transform_config_data");
var _step_define = require("../../../create_transform/components/step_define");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpandedRowPreviewPane = ({
  transformConfig
}) => {
  const {
    ml: {
      DataGrid
    }
  } = (0, _app_dependencies.useAppDependencies)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const {
    searchQuery,
    validationStatus,
    previewRequest,
    runtimeMappings
  } = (0, _react.useMemo)(() => (0, _step_define.applyTransformConfigToDefineState)((0, _step_define.getDefaultStepDefineState)({}), transformConfig), [transformConfig]);
  const transformConfigQuery = (0, _react.useMemo)(() => (0, _common.getTransformConfigQuery)(searchQuery), [searchQuery]);
  const dataViewTitle = Array.isArray(transformConfig.source.index) ? transformConfig.source.index.join(',') : transformConfig.source.index;
  const pivotPreviewProps = (0, _use_transform_config_data.useTransformConfigData)({
    getIndexPattern: () => dataViewTitle
  }, transformConfigQuery, validationStatus, previewRequest, runtimeMappings);
  return /*#__PURE__*/_react.default.createElement(DataGrid, (0, _extends2.default)({}, pivotPreviewProps, {
    dataTestSubj: "transformPivotPreview",
    toastNotifications: toastNotifications
  }));
};
exports.ExpandedRowPreviewPane = ExpandedRowPreviewPane;