"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRowMessagesPane = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _type_guards = require("../../../../../../common/api_schemas/type_guards");
var _use_api = require("../../../../hooks/use_api");
var _job_icon = require("../../../../components/job_icon");
var _common = require("../../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpandedRowMessagesPane = ({
  transformId
}) => {
  const [messages, setMessages] = (0, _react.useState)([]);
  const [msgCount, setMsgCount] = (0, _react.useState)(0);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [errorMessage, setErrorMessage] = (0, _react.useState)('');
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sorting, setSorting] = (0, _react.useState)({
    sort: {
      field: 'timestamp',
      direction: 'desc'
    }
  });
  const api = (0, _use_api.useApi)();
  const getMessagesFactory = (sortField = 'timestamp', sortDirection = 'desc') => {
    let concurrentLoads = 0;
    return async function getMessages() {
      concurrentLoads++;
      if (concurrentLoads > 1) {
        return;
      }
      setIsLoading(true);
      const messagesResp = await api.getTransformAuditMessages(transformId, sortField, sortDirection);
      if (!(0, _type_guards.isGetTransformsAuditMessagesResponseSchema)(messagesResp)) {
        setIsLoading(false);
        setErrorMessage(_i18n.i18n.translate('xpack.transform.transformList.transformDetails.messagesPane.errorMessage', {
          defaultMessage: 'Messages could not be loaded'
        }));
        return;
      }
      setIsLoading(false);
      setMessages(messagesResp.messages);
      setMsgCount(messagesResp.total);
      concurrentLoads--;
      if (concurrentLoads > 0) {
        concurrentLoads = 0;
        getMessages();
      }
    };
  };
  const {
    refresh: refreshMessage
  } = (0, _common.useRefreshTransformList)({
    onRefresh: getMessagesFactory()
  });
  const columns = [{
    name: refreshMessage ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.transform.transformList.refreshLabel', {
        defaultMessage: 'Refresh'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon
    // TODO: Replace this with ML's blurButtonOnClick when it's moved to a shared package
    , {
      onClick: e => {
        e.currentTarget.blur();
        refreshMessage();
      },
      iconType: "refresh",
      "aria-label": _i18n.i18n.translate('xpack.transform.transformList.refreshAriaLabel', {
        defaultMessage: 'Refresh'
      })
    })) : '',
    render: message => /*#__PURE__*/_react.default.createElement(_job_icon.JobIcon, {
      message: message
    }),
    width: _uiTheme.euiLightVars.euiSizeXL
  }, {
    field: 'timestamp',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.messagesPane.timeLabel', {
      defaultMessage: 'Time'
    }),
    render: timestamp => (0, _eui.formatDate)(timestamp, _constants.TIME_FORMAT),
    sortable: true
  }, {
    field: 'node_name',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.messagesPane.nodeLabel', {
      defaultMessage: 'Node'
    }),
    sortable: true
  }, {
    field: 'message',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.messagesPane.messageLabel', {
      defaultMessage: 'Message'
    }),
    width: '50%'
  }];
  const getPageOfMessages = ({
    index,
    size
  }) => {
    let list = messages;
    if (msgCount <= _constants.DEFAULT_MAX_AUDIT_MESSAGE_SIZE) {
      var _sorting$sort$field;
      const sortField = (_sorting$sort$field = sorting.sort.field) !== null && _sorting$sort$field !== void 0 ? _sorting$sort$field : 'timestamp';
      list = messages.sort((a, b) => {
        const prev = a[sortField];
        const curr = b[sortField];
        return sorting.sort.direction === 'asc' ? prev - curr : curr - prev;
      });
    }
    const listLength = list.length;
    const pageStart = index * size;
    return {
      pageOfMessages: list.slice(pageStart, pageStart + size),
      totalItemCount: listLength
    };
  };
  const onChange = ({
    page = {
      index: 0,
      size: 10
    },
    sort
  }) => {
    const {
      index,
      size
    } = page;
    setPageIndex(index);
    setPageSize(size);
    if (sort) {
      setSorting({
        sort
      });

      // Since we only show 500 messages, if user wants oldest messages first
      // we need to make sure we fetch them from elasticsearch
      if (msgCount > _constants.DEFAULT_MAX_AUDIT_MESSAGE_SIZE) {
        getMessagesFactory(sort.field, sort.direction)();
      }
    }
  };
  const {
    pageOfMessages,
    totalItemCount
  } = getPageOfMessages({
    index: pageIndex,
    size: pageSize
  });
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount,
    pageSizeOptions: [10, 20, 50],
    showPerPageOptions: true
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    hasBorder: false,
    paddingSize: "s",
    "data-test-subj": "transformMessagesTabContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: "transform__TransformTable__messagesPaneTable",
    items: pageOfMessages,
    columns: columns,
    compressed: true,
    loading: isLoading,
    error: errorMessage,
    pagination: pagination,
    onChange: onChange,
    sorting: sorting
  }));
};
exports.ExpandedRowMessagesPane = ExpandedRowMessagesPane;