"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRowHealthPane = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _transform_health_colored_dot = require("./transform_health_colored_dot");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpandedRowHealthPane = ({
  health
}) => {
  const {
    status,
    issues
  } = health;
  const sorting = {
    sort: {
      field: 'first_occurrence',
      direction: 'desc'
    }
  };
  const columns = [{
    field: 'first_occurrence',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.healthPane.firstOccurrenceLabel', {
      defaultMessage: 'First occurrence'
    }),
    render: firstOccurrence => (0, _eui.formatDate)(firstOccurrence, _constants.TIME_FORMAT),
    sortable: true
  }, {
    field: 'count',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.healthPane.countLabel', {
      defaultMessage: 'count'
    }),
    sortable: true,
    width: '60px'
  }, {
    field: 'issue',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.healthPane.issueLabel', {
      defaultMessage: 'Issue'
    }),
    sortable: true
  }, {
    field: 'details',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.healthPane.detailsLabel', {
      defaultMessage: 'Details'
    }),
    width: '50%'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    hasBorder: false,
    paddingSize: "s",
    "data-test-subj": "transformHealthTabContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_transform_health_colored_dot.TransformHealthColoredDot, {
    healthStatus: status,
    compact: false
  }), Array.isArray(issues) && issues.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "transformHealthTabContentIssueTable",
    items: issues,
    columns: columns,
    compressed: true,
    pagination: issues.length > 10,
    sorting: sorting
  })));
};
exports.ExpandedRowHealthPane = ExpandedRowHealthPane;