"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Section = exports.ExpandedRowDetailsPane = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Section = ({
  section
}) => {
  if (section.items.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, section.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    listItems: section.items
  }));
};
exports.Section = Section;
const ExpandedRowDetailsPane = ({
  sections,
  dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'transformDetailsTabContent'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '50%'
    }
  }, sections.filter(s => s.position === 'left').map(s => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: s.title
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(Section, {
    section: s
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '50%'
    }
  }, sections.filter(s => s.position === 'right').map(s => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: s.title
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(Section, {
    section: s
  }))))));
};
exports.ExpandedRowDetailsPane = ExpandedRowDetailsPane;