"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformUpdateButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _type_guards = require("../../../../../../common/api_schemas/type_guards");
var _errors = require("../../../../../../common/utils/errors");
var _common = require("../../../../common");
var _app_dependencies = require("../../../../app_dependencies");
var _use_api = require("../../../../hooks/use_api");
var _use_edit_transform_flyout = require("./use_edit_transform_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditTransformUpdateButton = ({
  closeFlyout
}) => {
  const api = (0, _use_api.useApi)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const requestConfig = (0, _use_edit_transform_flyout.useEditTransformFlyout)('requestConfig');
  const isUpdateButtonDisabled = (0, _use_edit_transform_flyout.useEditTransformFlyout)('isUpdateButtonDisabled');
  const config = (0, _use_edit_transform_flyout.useEditTransformFlyout)('config');
  const {
    apiError
  } = (0, _use_edit_transform_flyout.useEditTransformFlyout)('actions');
  async function submitFormHandler() {
    apiError(undefined);
    const transformId = config.id;
    const resp = await api.updateTransform(transformId, requestConfig);
    if (!(0, _type_guards.isPostTransformsUpdateResponseSchema)(resp)) {
      apiError((0, _errors.getErrorMessage)(resp));
      return;
    }
    toastNotifications.addSuccess(_i18n.i18n.translate('xpack.transform.transformList.editTransformSuccessMessage', {
      defaultMessage: 'Transform {transformId} updated.',
      values: {
        transformId
      }
    }));
    closeFlyout();
    _common.refreshTransformList$.next(_common.REFRESH_TRANSFORM_LIST_STATE.REFRESH);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "transformEditFlyoutUpdateButton",
    onClick: submitFormHandler,
    fill: true,
    isDisabled: isUpdateButtonDisabled
  }, _i18n.i18n.translate('xpack.transform.transformList.editFlyoutUpdateButtonText', {
    defaultMessage: 'Update'
  }));
};
exports.EditTransformUpdateButton = EditTransformUpdateButton;