"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformFlyoutForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _edit_transform_flyout_form_text_input = require("./edit_transform_flyout_form_text_input");
var _edit_transform_retention_policy = require("./edit_transform_retention_policy");
var _edit_transform_ingest_pipeline = require("./edit_transform_ingest_pipeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditTransformFlyoutForm = () => /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form_text_input.EditTransformFlyoutFormTextInput, {
  field: "description",
  label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormDescriptionLabel', {
    defaultMessage: 'Description'
  })
}), /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form_text_input.EditTransformFlyoutFormTextInput, {
  field: "frequency",
  label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormFrequencyLabel', {
    defaultMessage: 'Frequency'
  }),
  helpText: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormFrequencyHelpText', {
    defaultMessage: 'The interval to check for changes in source indices when the transform runs continuously.'
  })
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}), /*#__PURE__*/_react.default.createElement(_edit_transform_retention_policy.EditTransformRetentionPolicy, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
  "data-test-subj": "transformEditAccordionDestination",
  id: "transformEditAccordionDestination",
  buttonContent: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormDestinationButtonContent', {
    defaultMessage: 'Destination configuration'
  }),
  paddingSize: "s"
}, /*#__PURE__*/_react.default.createElement("div", {
  "data-test-subj": "transformEditAccordionDestinationContent"
}, /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form_text_input.EditTransformFlyoutFormTextInput, {
  field: "destinationIndex",
  label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormDestinationIndexLabel', {
    defaultMessage: 'Destination index'
  })
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement("div", {
  "data-test-subj": "transformEditAccordionIngestPipelineContent"
}, /*#__PURE__*/_react.default.createElement(_edit_transform_ingest_pipeline.EditTransformIngestPipeline, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
  "data-test-subj": "transformEditAccordionAdvancedSettings",
  id: "transformEditAccordionAdvancedSettings",
  buttonContent: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormAdvancedSettingsButtonContent', {
    defaultMessage: 'Advanced settings'
  }),
  paddingSize: "s"
}, /*#__PURE__*/_react.default.createElement("div", {
  "data-test-subj": "transformEditAccordionAdvancedSettingsContent"
}, /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form_text_input.EditTransformFlyoutFormTextInput, {
  field: "docsPerSecond",
  helpText: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormDocsPerSecondHelpText', {
    defaultMessage: 'To enable throttling, set a limit of documents to input per second.'
  }),
  label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormDocsPerSecondLabel', {
    defaultMessage: 'Documents per second'
  })
}), /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form_text_input.EditTransformFlyoutFormTextInput, {
  field: "maxPageSearchSize",
  helpText: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormMaxPageSearchSizeHelpText', {
    defaultMessage: 'The initial page size to use for the composite aggregation for each checkpoint.'
  }),
  label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormMaxPageSearchSizeLabel', {
    defaultMessage: 'Maximum page search size'
  }),
  placeHolder: true
}), /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form_text_input.EditTransformFlyoutFormTextInput, {
  field: "numFailureRetries",
  helpText: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormNumFailureRetriesHelpText', {
    defaultMessage: 'The number of retries on a recoverable failure before the transform task is marked as failed. Set it to -1 for infinite retries.'
  }),
  label: _i18n.i18n.translate('xpack.transform.transformList.numFailureRetriesLabel', {
    defaultMessage: 'Number of failure retries'
  })
}))));
exports.EditTransformFlyoutForm = EditTransformFlyoutForm;