"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStopAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _authorization = require("../../../../lib/authorization");
var _hooks = require("../../../../hooks");
var _stop_action_name = require("./stop_action_name");
var _managed_transforms_utils = require("../../../../common/managed_transforms_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStopAction = forceDisable => {
  const {
    canStartStopTransform
  } = (0, _react.useContext)(_authorization.AuthorizationContext).capabilities;
  const stopTransforms = (0, _hooks.useStopTransforms)();
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([]);
  const closeModal = () => setModalVisible(false);
  const openModal = newItems => {
    if (Array.isArray(newItems)) {
      setItems(newItems);
      setModalVisible(true);
    }
  };
  const stopAndCloseModal = (0, _react.useCallback)(transformSelection => {
    setModalVisible(false);
    stopTransforms(transformSelection.map(t => ({
      id: t.id,
      state: t.stats.state
    })));
  }, [stopTransforms]);
  const clickHandler = (0, _react.useCallback)(i => stopTransforms([{
    id: i.id,
    state: i.stats.state
  }]), [stopTransforms]);
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_stop_action_name.StopActionName, {
      items: [item],
      forceDisable: forceDisable
    }),
    available: item => item.stats.state !== _constants.TRANSFORM_STATE.STOPPED,
    enabled: item => !(0, _stop_action_name.isStopActionDisabled)([item], canStartStopTransform, forceDisable),
    description: _stop_action_name.stopActionNameText,
    icon: 'stop',
    type: 'icon',
    onClick: item => {
      if ((0, _managed_transforms_utils.isManagedTransform)(item)) {
        openModal([item]);
      } else {
        clickHandler(item);
      }
    },
    'data-test-subj': 'transformActionStop'
  }), [canStartStopTransform, clickHandler, forceDisable]);
  return {
    action,
    closeModal,
    openModal,
    isModalVisible,
    items,
    stopAndCloseModal
  };
};
exports.useStopAction = useStopAction;