"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startActionNameText = exports.isStartActionDisabled = exports.StartActionName = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _authorization = require("../../../../lib/authorization");
var _common = require("../../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startActionNameText = _i18n.i18n.translate('xpack.transform.transformList.startActionNameText', {
  defaultMessage: 'Start'
});
exports.startActionNameText = startActionNameText;
const isStartActionDisabled = (items, canStartStopTransform, transformNodes) => {
  // Disable start for batch transforms which have completed.
  const completedBatchTransform = items.some(i => (0, _common.isCompletedBatchTransform)(i));
  // Disable start action if one of the transforms is already started or trying to restart will throw error
  const startedTransform = items.some(i => i.stats.state === _constants.TRANSFORM_STATE.STARTED);
  return !canStartStopTransform || completedBatchTransform || startedTransform || items.length === 0 || transformNodes === 0;
};
exports.isStartActionDisabled = isStartActionDisabled;
const StartActionName = ({
  items,
  forceDisable,
  transformNodes
}) => {
  const {
    canStartStopTransform
  } = (0, _react.useContext)(_authorization.AuthorizationContext).capabilities;
  const isBulkAction = items.length > 1;

  // Disable start for batch transforms which have completed.
  const completedBatchTransform = items.some(i => (0, _common.isCompletedBatchTransform)(i));
  // Disable start action if one of the transforms is already started or trying to restart will throw error
  const startedTransform = items.some(i => i.stats.state === _constants.TRANSFORM_STATE.STARTED);
  let startedTransformMessage;
  let completedBatchTransformMessage;
  if (isBulkAction === true) {
    startedTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.startedTransformBulkToolTip', {
      defaultMessage: 'One or more transforms are already started.'
    });
    completedBatchTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.cannotRestartCompleteBatchTransformBulkActionToolTip', {
      defaultMessage: 'One or more transforms are completed batch transforms and cannot be restarted.'
    });
  } else {
    startedTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.startedTransformToolTip', {
      defaultMessage: '{transformId} is already started.',
      values: {
        transformId: items[0] && items[0].config.id
      }
    });
    completedBatchTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.cannotRestartCompleteBatchTransformToolTip', {
      defaultMessage: '{transformId} is a completed batch transform and cannot be restarted.',
      values: {
        transformId: items[0] && items[0].config.id
      }
    });
  }
  const actionIsDisabled = isStartActionDisabled(items, canStartStopTransform, transformNodes);
  let content;
  if (actionIsDisabled && items.length > 0) {
    if (!canStartStopTransform) {
      content = (0, _authorization.createCapabilityFailureMessage)('canStartStopTransform');
    } else if (completedBatchTransform) {
      content = completedBatchTransformMessage;
    } else if (startedTransform) {
      content = startedTransformMessage;
    }
  }
  if ((forceDisable === true || actionIsDisabled) && content !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: content
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, startActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, startActionNameText);
};
exports.StartActionName = StartActionName;