"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleNowActionNameText = exports.isScheduleNowActionDisabled = exports.ScheduleNowActionName = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _authorization = require("../../../../lib/authorization");
var _common = require("../../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scheduleNowActionNameText = _i18n.i18n.translate('xpack.transform.transformList.scheduleNowActionNameText', {
  defaultMessage: 'Schedule now'
});
exports.scheduleNowActionNameText = scheduleNowActionNameText;
const isScheduleNowActionDisabled = (items, canScheduleNowTransform, transformNodes) => {
  // Disable schedule-now for batch transforms which have completed.
  const completedBatchTransform = items.some(i => (0, _common.isCompletedBatchTransform)(i));
  return !canScheduleNowTransform || completedBatchTransform || items.length === 0 || transformNodes === 0;
};
exports.isScheduleNowActionDisabled = isScheduleNowActionDisabled;
const ScheduleNowActionName = ({
  items,
  forceDisable,
  transformNodes
}) => {
  const {
    canScheduleNowTransform
  } = (0, _react.useContext)(_authorization.AuthorizationContext).capabilities;
  const isBulkAction = items.length > 1;

  // Disable schedule-now for batch transforms which have completed.
  const completedBatchTransform = items.some(i => (0, _common.isCompletedBatchTransform)(i));
  let completedBatchTransformMessage;
  if (isBulkAction === true) {
    completedBatchTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.cannotScheduleNowCompleteBatchTransformBulkActionToolTip', {
      defaultMessage: 'One or more transforms are completed batch transforms and cannot be scheduled to process data instantly.'
    });
  } else {
    completedBatchTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.cannotScheduleNowCompleteBatchTransformToolTip', {
      defaultMessage: '{transformId} is a completed batch transform and cannot be scheduled to process data instantly.',
      values: {
        transformId: items[0] && items[0].config.id
      }
    });
  }
  const actionIsDisabled = isScheduleNowActionDisabled(items, canScheduleNowTransform, transformNodes);
  let content = _i18n.i18n.translate('xpack.transform.transformList.scheduleNowToolTip', {
    defaultMessage: 'Schedule the transform to instantly process data without waiting for the configured interval between checks for changes in the source indices.'
  });
  if (actionIsDisabled && items.length > 0) {
    if (!canScheduleNowTransform) {
      content = (0, _authorization.createCapabilityFailureMessage)('canScheduleNowTransform');
    } else if (completedBatchTransform) {
      content = completedBatchTransformMessage;
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: content
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, scheduleNowActionNameText));
};
exports.ScheduleNowActionName = ScheduleNowActionName;