"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResetAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _authorization = require("../../../../lib/authorization");
var _reset_action_name = require("./reset_action_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useResetAction = forceDisable => {
  const {
    canResetTransform
  } = (0, _react.useContext)(_authorization.AuthorizationContext).capabilities;
  const resetTransforms = (0, _hooks.useResetTransforms)();
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([]);
  const shouldForceReset = (0, _react.useMemo)(() => items.some(i => i.stats.state === _constants.TRANSFORM_STATE.FAILED), [items]);
  const closeModal = () => setModalVisible(false);
  const resetAndCloseModal = () => {
    setModalVisible(false);
    resetTransforms({
      transformsInfo: items.map(i => ({
        id: i.config.id,
        state: i.stats.state
      }))
    });
  };
  const openModal = newItems => {
    if (Array.isArray(newItems)) {
      setItems(newItems);
      setModalVisible(true);
    }
  };
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_reset_action_name.ResetActionName, {
      canResetTransform,
      disabled: (0, _reset_action_name.isResetActionDisabled)([item], forceDisable),
      isBulkAction: false
    }),
    enabled: item => !(0, _reset_action_name.isResetActionDisabled)([item], forceDisable) && canResetTransform,
    description: _reset_action_name.resetActionNameText,
    icon: 'refresh',
    type: 'icon',
    onClick: item => openModal([item]),
    'data-test-subj': 'transformActionReset'
  }), [canResetTransform, forceDisable]);
  return {
    action,
    closeModal,
    resetAndCloseModal,
    isModalVisible,
    items,
    openModal,
    shouldForceReset
  };
};
exports.useResetAction = useResetAction;