"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resetActionNameText = exports.isResetActionDisabled = exports.ResetActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _authorization = require("../../../../lib/authorization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resetActionNameText = _i18n.i18n.translate('xpack.transform.transformList.resetActionNameText', {
  defaultMessage: 'Reset'
});
exports.resetActionNameText = resetActionNameText;
const transformCanNotBeReseted = i => ![_constants.TRANSFORM_STATE.STOPPED, _constants.TRANSFORM_STATE.FAILED].includes(i.stats.state);
const isResetActionDisabled = (items, forceDisable) => {
  const disabled = items.some(transformCanNotBeReseted);
  return forceDisable === true || disabled;
};
exports.isResetActionDisabled = isResetActionDisabled;
const ResetActionName = ({
  canResetTransform,
  disabled,
  isBulkAction
}) => {
  const bulkResetButtonDisabledText = _i18n.i18n.translate('xpack.transform.transformList.resetBulkActionDisabledToolTipContent', {
    defaultMessage: 'One or more selected transforms must be stopped to be reset.'
  });
  const resetButtonDisabledText = _i18n.i18n.translate('xpack.transform.transformList.resetActionDisabledToolTipContent', {
    defaultMessage: 'Stop the transform in order to reset it.'
  });
  if (disabled || !canResetTransform) {
    let content;
    if (disabled) {
      content = isBulkAction ? bulkResetButtonDisabledText : resetButtonDisabledText;
    } else {
      content = (0, _authorization.createCapabilityFailureMessage)('canResetTransform');
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: content
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, resetActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, resetActionNameText);
};
exports.ResetActionName = ResetActionName;