"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReauthorizeAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sort_transforms_to_reauthorize = require("./sort_transforms_to_reauthorize");
var _reauthorization_utils = require("../../../../common/reauthorization_utils");
var _use_reauthorize_transform = require("../../../../hooks/use_reauthorize_transform");
var _reauthorize_action_name = require("./reauthorize_action_name");
var _authorization = require("../../../../lib/authorization");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useReauthorizeAction = (forceDisable, transformNodes) => {
  const {
    canStartStopTransform
  } = (0, _react.useContext)(_authorization.AuthorizationContext).capabilities;
  const reauthorizeTransforms = (0, _use_reauthorize_transform.useReauthorizeTransforms)();
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([]);
  const closeModal = () => setModalVisible(false);
  const reauthorizeAndCloseModal = () => {
    setModalVisible(false);
    const {
      transformIds
    } = (0, _sort_transforms_to_reauthorize.sortTransformsToReauthorize)(items);
    reauthorizeTransforms(transformIds);
  };
  const openModal = newItems => {
    if (Array.isArray(newItems)) {
      setItems(newItems);
      setModalVisible(true);
    }
  };
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_reauthorize_action_name.ReauthorizeActionName, {
      items: [item],
      forceDisable: forceDisable,
      transformNodes: transformNodes
    }),
    available: item => (0, _reauthorization_utils.needsReauthorization)(item),
    enabled: item => !(0, _reauthorize_action_name.isReauthorizeActionDisabled)([item], canStartStopTransform, transformNodes),
    description: _reauthorize_action_name.reauthorizeActionNameText,
    icon: 'alert',
    type: 'icon',
    color: 'warning',
    onClick: item => openModal([item]),
    'data-test-subj': 'transformActionReauthorize'
  }), [canStartStopTransform, forceDisable, transformNodes]);
  return {
    action,
    closeModal,
    isModalVisible,
    items,
    openModal,
    reauthorizeAndCloseModal
  };
};
exports.useReauthorizeAction = useReauthorizeAction;