"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reauthorizeActionNameText = exports.isReauthorizeActionDisabled = exports.ReauthorizeActionName = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reauthorization_utils = require("../../../../common/reauthorization_utils");
var _authorization = require("../../../../lib/authorization");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reauthorizeActionNameText = _i18n.i18n.translate('xpack.transform.transformList.reauthorizeActionNameText', {
  defaultMessage: 'Reauthorize'
});
exports.reauthorizeActionNameText = reauthorizeActionNameText;
const isReauthorizeActionDisabled = (items, canStartStopTransform, transformNodes) => {
  return !canStartStopTransform || items.length === 0 || transformNodes === 0 || !items.some(_reauthorization_utils.needsReauthorization);
};
exports.isReauthorizeActionDisabled = isReauthorizeActionDisabled;
const ReauthorizeActionName = ({
  items,
  forceDisable,
  transformNodes
}) => {
  const {
    canStartStopTransform
  } = (0, _react.useContext)(_authorization.AuthorizationContext).capabilities;

  // Disable start for batch transforms which have completed.
  const someNeedsReauthorization = items.some(_reauthorization_utils.needsReauthorization);
  const actionIsDisabled = isReauthorizeActionDisabled(items, canStartStopTransform, transformNodes);
  let content;
  if (actionIsDisabled && items.length > 0) {
    if (!canStartStopTransform && someNeedsReauthorization) {
      content = (0, _authorization.createCapabilityFailureMessage)('canReauthorizeTransform');
    }
    if (!someNeedsReauthorization) {
      content = _i18n.i18n.translate('xpack.transform.transformList.reauthorizeBulkActionDisabledToolTipContent', {
        defaultMessage: 'One or more selected transforms must require reauthorization.'
      });
    }
  }
  const text = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, reauthorizeActionNameText);
  if ((forceDisable === true || actionIsDisabled) && content !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: content
    }, text);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, text);
};
exports.ReauthorizeActionName = ReauthorizeActionName;