"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/discover-plugin/common");
var _use_search_items = require("../../../../hooks/use_search_items");
var _app_dependencies = require("../../../../app_dependencies");
var _discover_action_name = require("./discover_action_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDataViewTitleFromTargetIndex = item => Array.isArray(item.config.dest.index) ? item.config.dest.index.join(',') : item.config.dest.index;
const useDiscoverAction = forceDisable => {
  var _capabilities$discove;
  const {
    share,
    data: {
      dataViews: dataViewsContract
    },
    application: {
      capabilities
    }
  } = (0, _app_dependencies.useAppDependencies)();
  const isDiscoverAvailable = !!((_capabilities$discove = capabilities.discover) !== null && _capabilities$discove !== void 0 && _capabilities$discove.show);
  const {
    getDataViewIdByTitle,
    loadDataViews
  } = (0, _use_search_items.useSearchItems)(undefined);
  const [dataViewsLoaded, setDataViewsLoaded] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    async function checkDataViewAvailability() {
      await loadDataViews(dataViewsContract);
      setDataViewsLoaded(true);
    }
    checkDataViewAvailability();
  }, [loadDataViews, dataViewsContract]);
  const clickHandler = (0, _react.useCallback)(item => {
    const locator = share.url.locators.get(_common.DISCOVER_APP_LOCATOR);
    if (!locator) return;
    const dataViewTitle = getDataViewTitleFromTargetIndex(item);
    const dataViewId = getDataViewIdByTitle(dataViewTitle);
    locator.navigateSync({
      indexPatternId: dataViewId
    });
  }, [getDataViewIdByTitle, share]);
  const dataViewExists = (0, _react.useCallback)(item => {
    const dataViewTitle = getDataViewTitleFromTargetIndex(item);
    const dataViewId = getDataViewIdByTitle(dataViewTitle);
    return dataViewId !== undefined;
  }, [getDataViewIdByTitle]);
  const action = (0, _react.useMemo)(() => ({
    name: item => {
      return /*#__PURE__*/_react.default.createElement(_discover_action_name.DiscoverActionName, {
        items: [item],
        dataViewExists: dataViewExists(item)
      });
    },
    available: () => isDiscoverAvailable,
    enabled: item => dataViewsLoaded && !(0, _discover_action_name.isDiscoverActionDisabled)([item], forceDisable, dataViewExists(item)),
    description: _discover_action_name.discoverActionNameText,
    icon: 'visTable',
    type: 'icon',
    onClick: clickHandler,
    'data-test-subj': 'transformActionDiscover'
  }), [forceDisable, dataViewExists, dataViewsLoaded, isDiscoverAvailable, clickHandler]);
  return {
    action
  };
};
exports.useDiscoverAction = useDiscoverAction;