"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDeleteActionDisabled = exports.deleteActionNameText = exports.DeleteActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _authorization = require("../../../../lib/authorization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteActionNameText = _i18n.i18n.translate('xpack.transform.transformList.deleteActionNameText', {
  defaultMessage: 'Delete'
});
exports.deleteActionNameText = deleteActionNameText;
const transformCanNotBeDeleted = i => ![_constants.TRANSFORM_STATE.STOPPED, _constants.TRANSFORM_STATE.FAILED].includes(i.stats.state);
const isDeleteActionDisabled = (items, forceDisable) => {
  const disabled = items.some(transformCanNotBeDeleted);
  return forceDisable === true || disabled;
};
exports.isDeleteActionDisabled = isDeleteActionDisabled;
const DeleteActionName = ({
  canDeleteTransform,
  disabled,
  isBulkAction
}) => {
  const bulkDeleteButtonDisabledText = _i18n.i18n.translate('xpack.transform.transformList.deleteBulkActionDisabledToolTipContent', {
    defaultMessage: 'One or more selected transforms must be stopped in order to be deleted.'
  });
  const deleteButtonDisabledText = _i18n.i18n.translate('xpack.transform.transformList.deleteActionDisabledToolTipContent', {
    defaultMessage: 'Stop the transform in order to delete it.'
  });
  if (disabled || !canDeleteTransform) {
    let content;
    if (disabled) {
      content = isBulkAction ? bulkDeleteButtonDisabledText : deleteButtonDisabledText;
    } else {
      content = (0, _authorization.createCapabilityFailureMessage)('canDeleteTransform');
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: content
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deleteActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deleteActionNameText);
};
exports.DeleteActionName = DeleteActionName;