"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPercentilesAggConfig = getPercentilesAggConfig;
var _percentiles_form_component = require("./percentiles_form_component");
var _common = require("../../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * TODO this callback has been moved.
 * The logic of parsing the string should be improved.
 */
function parsePercentsInput(inputValue) {
  if (inputValue !== undefined) {
    const strVals = inputValue.split(',');
    const percents = [];
    for (const str of strVals) {
      if (str.trim().length > 0 && isNaN(str) === false) {
        const val = Number(str);
        if (val >= 0 && val <= 100) {
          percents.push(val);
        } else {
          return [];
        }
      }
    }
    return percents;
  }
  return [];
}

// Input string should only include comma separated numbers
function isValidPercentsInput(inputValue) {
  return /^[0-9]+(,[0-9]+)*$/.test(inputValue);
}
function getPercentilesAggConfig(commonConfig) {
  const field = (0, _common.isPivotAggsConfigWithUiBase)(commonConfig) ? commonConfig.field : null;
  return {
    ...commonConfig,
    isSubAggsSupported: false,
    isMultiField: false,
    AggFormComponent: _percentiles_form_component.PercentilesAggForm,
    field,
    aggConfig: {
      percents: _common.PERCENTILES_AGG_DEFAULT_PERCENTS.toString()
    },
    setUiConfigFromEs(esAggDefinition) {
      const {
        field: esField,
        percents
      } = esAggDefinition;
      this.field = esField;
      this.aggConfig.percents = percents.join(',');
    },
    getEsAggConfig() {
      if (!this.isValid()) {
        return null;
      }
      return {
        field: this.field,
        percents: parsePercentsInput(this.aggConfig.percents)
      };
    },
    isValid() {
      return typeof this.aggConfig.percents === 'string' && isValidPercentsInput(this.aggConfig.percents);
    }
  };
}