"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterTermForm = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_data_search = require("../../../../../../../hooks/use_data_search");
var _type_guards = require("../../../../../../../../../common/api_schemas/type_guards");
var _wizard = require("../../../../wizard/wizard");
var _app_dependencies = require("../../../../../../../app_dependencies");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Form component for the term filter aggregation.
 */
const FilterTermForm = ({
  config,
  onChange,
  selectedField
}) => {
  const {
    dataView,
    runtimeMappings
  } = (0, _react.useContext)(_wizard.CreateTransformWizardContext);
  const dataSearch = (0, _use_data_search.useDataSearch)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const [options, setOptions] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const onSearchChange = newSearchValue => {
    setSearchValue(newSearchValue);
  };
  const updateConfig = (0, _react.useCallback)(update => {
    onChange({
      config: {
        ...config,
        ...update
      }
    });
  }, [config, onChange]);
  (0, _react.useEffect)(() => {
    const abortController = new AbortController();
    const fetchOptions = (0, _lodash.debounce)(async () => {
      if (selectedField === undefined) return;
      setIsLoading(true);
      setOptions([]);
      const esSearchRequest = {
        index: dataView.title,
        body: {
          ...(runtimeMappings !== undefined ? {
            runtime_mappings: runtimeMappings
          } : {}),
          query: {
            wildcard: {
              [selectedField]: {
                value: `*${searchValue}*`
              }
            }
          },
          aggs: {
            field_values: {
              terms: {
                field: selectedField,
                size: 10
              }
            }
          },
          size: 0
        }
      };
      const response = await dataSearch(esSearchRequest, abortController.signal);
      setIsLoading(false);
      if (!((0, _type_guards.isEsSearchResponseWithAggregations)(response) && (0, _type_guards.isMultiBucketAggregate)(response.aggregations.field_values))) {
        toastNotifications.addWarning(_i18n.i18n.translate('xpack.transform.agg.popoverForm.filerAgg.term.errorFetchSuggestions', {
          defaultMessage: 'Unable to fetch suggestions'
        }));
        return;
      }
      setOptions(response.aggregations.field_values.buckets.map(value => ({
        label: value.key + ''
      })));
    }, 600);
    fetchOptions();
    return () => {
      // make sure the ongoing request is canceled
      fetchOptions.cancel();
      abortController.abort();
    };
    /* eslint-disable-next-line react-hooks/exhaustive-deps */
  }, [selectedField]);
  (0, _react.useEffect)(() => {
    // Simulate initial load.
    onSearchChange('');
  }, []);
  (0, _useUpdateEffect.default)(() => {
    // Reset value control on field change
    if (!selectedField) return;
    onChange({
      config: {
        value: undefined
      }
    });
  }, [selectedField]);
  const selectedOptions = config !== null && config !== void 0 && config.value ? [{
    label: config.value
  }] : undefined;
  if (selectedField === undefined) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.agg.popoverForm.filerAgg.term.valueLabel",
      defaultMessage: "Value"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    async: true,
    isLoading: isLoading,
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selectedOptions,
    isClearable: false,
    onChange: selected => {
      updateConfig({
        value: selected.length > 0 ? selected[0].label : undefined
      });
    },
    onCreateOption: value => {
      updateConfig({
        value
      });
    },
    onSearchChange: onSearchChange,
    "data-test-subj": "transformFilterTermValueSelector"
  }));
};
exports.FilterTermForm = FilterTermForm;