"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterRangeForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUTTON_SIZE = 40;
/**
 * Form component for the range filter aggregation for number type fields.
 */
const FilterRangeForm = ({
  config,
  onChange
}) => {
  var _config$from, _config$to, _config$includeFrom, _config$includeTo;
  const from = (_config$from = config === null || config === void 0 ? void 0 : config.from) !== null && _config$from !== void 0 ? _config$from : '';
  const to = (_config$to = config === null || config === void 0 ? void 0 : config.to) !== null && _config$to !== void 0 ? _config$to : '';
  const includeFrom = (_config$includeFrom = config === null || config === void 0 ? void 0 : config.includeFrom) !== null && _config$includeFrom !== void 0 ? _config$includeFrom : false;
  const includeTo = (_config$includeTo = config === null || config === void 0 ? void 0 : config.includeTo) !== null && _config$includeTo !== void 0 ? _config$includeTo : false;
  const updateConfig = (0, _react.useCallback)(update => {
    onChange({
      config: {
        ...config,
        ...update
      }
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [config]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.agg.popoverForm.filerAgg.range.greaterThanLabel",
      defaultMessage: "Greater than"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: from,
    max: to !== '' ? to : undefined,
    onChange: e => {
      updateConfig({
        from: e.target.value === '' ? undefined : Number(e.target.value)
      });
    },
    step: "any",
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      minWidth: BUTTON_SIZE,
      style: {
        maxWidth: BUTTON_SIZE
      },
      onChange: e => {
        updateConfig({
          includeFrom: e.target.checked
        });
      },
      fill: includeFrom
    }, includeFrom ? '≥' : '>')
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.agg.popoverForm.filerAgg.range.lessThanLabel",
      defaultMessage: "Less than"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: to,
    min: from !== '' ? from : undefined,
    onChange: e => {
      updateConfig({
        to: e.target.value === '' ? undefined : Number(e.target.value)
      });
    },
    step: "any",
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      minWidth: BUTTON_SIZE,
      style: {
        maxWidth: BUTTON_SIZE
      },
      onClick: () => {
        updateConfig({
          includeTo: !includeTo
        });
      },
      fill: includeTo
    }, includeTo ? '≤' : '<')
  })))));
};
exports.FilterRangeForm = FilterRangeForm;