"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByListForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _group_by_label_form = require("./group_by_label_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupByListForm = ({
  deleteHandler,
  list,
  onChange,
  options
}) => {
  const listKeys = Object.keys(list);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, listKeys.map((aggName, i) => {
    const otherAggNames = listKeys.filter(k => k !== aggName);
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: aggName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "s",
      "data-test-subj": `transformGroupByEntry ${i}`
    }, /*#__PURE__*/_react.default.createElement(_group_by_label_form.GroupByLabelForm, {
      deleteHandler: deleteHandler,
      item: list[aggName],
      otherAggNames: otherAggNames,
      onChange: item => onChange(aggName, item),
      options: options
    })), listKeys.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }));
};
exports.GroupByListForm = GroupByListForm;