"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _common = require("../../../../../../common/types/common");
var _common2 = require("../../../../common");
var _pivot_aggs = require("../../../../common/pivot_aggs");
var _get_agg_form_config = require("../step_define/common/get_agg_form_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopoverForm = ({
  defaultData,
  otherAggNames,
  onChange,
  options
}) => {
  const [aggConfigDef, setAggConfigDef] = (0, _react.useState)((0, _lodash.cloneDeep)(defaultData));
  const [aggName, setAggName] = (0, _react.useState)(defaultData.aggName);
  const [agg, setAgg] = (0, _react.useState)(defaultData.agg);
  const [field, setField] = (0, _react.useState)((0, _common2.isPivotAggsConfigWithUiBase)(defaultData) ? defaultData.field : '');
  const isUnsupportedAgg = !(0, _common2.isPivotAggsConfigWithUiBase)(defaultData);

  // Update configuration based on the aggregation type
  (0, _react.useEffect)(() => {
    if (agg === aggConfigDef.agg) return;
    const config = (0, _get_agg_form_config.getAggFormConfig)(agg, {
      parentAgg: aggConfigDef.parentAgg,
      subAggs: aggConfigDef.subAggs,
      agg,
      aggName,
      dropDownName: aggName,
      field
    });
    setAggConfigDef(config);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [agg, aggConfigDef]);
  (0, _useUpdateEffect.default)(() => {
    if ((0, _pivot_aggs.isPivotAggsWithExtendedForm)(aggConfigDef)) {
      const name = aggConfigDef.getAggName ? aggConfigDef.getAggName() : undefined;
      if (name !== undefined) {
        setAggName(name);
      }
    }
  }, [aggConfigDef]);
  const availableFields = [];
  const availableAggs = [];
  function updateAgg(aggVal) {
    setAgg(aggVal);
  }
  function getUpdatedItem() {
    let resultField = field;
    if ((0, _common2.isPivotAggsConfigWithUiBase)(aggConfigDef) && !aggConfigDef.isMultiField && Array.isArray(field)) {
      // reset to a single field in case agg doesn't support multiple fields
      resultField = field[0];
    }
    const updatedItem = {
      ...aggConfigDef,
      agg,
      aggName,
      dropDownName: defaultData.dropDownName,
      ...(isUnsupportedAgg ? {} : {
        field: resultField
      })
    };
    return updatedItem;
  }
  if (!isUnsupportedAgg) {
    const optionsArr = (0, _common.dictionaryToArray)(options);
    optionsArr.filter(o => o.agg === defaultData.agg).forEach(o => {
      availableFields.push({
        text: o.field
      });
    });
    optionsArr.filter(o => (0, _common2.isPivotAggsConfigWithUiBase)(defaultData) && (Array.isArray(defaultData.field) ? defaultData.field.includes(o.field) : o.field === defaultData.field)).forEach(o => {
      availableAggs.push({
        text: o.agg
      });
    });
  }
  let aggNameError = '';
  let validAggName = (0, _common2.isAggName)(aggName);
  if (!validAggName) {
    aggNameError = _i18n.i18n.translate('xpack.transform.agg.popoverForm.aggNameInvalidCharError', {
      defaultMessage: 'Invalid name. The characters "[", "]", and ">" are not allowed and the name must not start or end with a space character.'
    });
  }
  if (validAggName) {
    validAggName = !otherAggNames.includes(aggName);
    aggNameError = _i18n.i18n.translate('xpack.transform.agg.popoverForm.aggNameAlreadyUsedError', {
      defaultMessage: 'Another aggregation already uses that name.'
    });
  }
  let formValid = validAggName;
  if ((0, _pivot_aggs.isPivotAggsWithExtendedForm)(aggConfigDef)) {
    formValid = validAggName && aggConfigDef.isValid();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    css: {
      width: '300px'
    },
    "data-test-subj": 'transformAggPopoverForm_' + aggName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: !validAggName && [aggNameError],
    isInvalid: !validAggName,
    helpText: isUnsupportedAgg ? _i18n.i18n.translate('xpack.transform.agg.popoverForm.unsupportedAggregationHelpText', {
      defaultMessage: 'Only the aggregation name can be edited in this form. Please use the advanced editor to edit the other parts of the aggregation.'
    }) : '',
    label: _i18n.i18n.translate('xpack.transform.agg.popoverForm.nameLabel', {
      defaultMessage: 'Aggregation name'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: aggName,
    isInvalid: !validAggName,
    onChange: e => setAggName(e.target.value),
    "data-test-subj": "transformAggName"
  })), availableFields.length > 0 ? aggConfigDef.isMultiField ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.agg.popoverForm.fieldsLabel', {
      defaultMessage: 'Fields'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    options: availableFields.map(v => {
      return {
        value: v.text,
        label: v.text
      };
    }),
    selectedOptions: !!field ? (typeof field === 'string' ? [field] : field).map(v => ({
      value: v,
      label: v
    })) : [],
    onChange: e => {
      const res = e.map(v => v.value);
      setField(res);
    },
    isClearable: false,
    "data-test-subj": "transformAggFields"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.agg.popoverForm.fieldLabel', {
      defaultMessage: 'Field'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: availableFields,
    value: field,
    onChange: e => setField(e.target.value),
    "data-test-subj": "transformAggField"
  })) : null, availableAggs.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.agg.popoverForm.aggLabel', {
      defaultMessage: 'Aggregation'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: availableAggs,
    value: agg,
    onChange: e => updateAgg(e.target.value),
    "data-test-subj": "transformAggType"
  })), (0, _pivot_aggs.isPivotAggsWithExtendedForm)(aggConfigDef) ? /*#__PURE__*/_react.default.createElement(aggConfigDef.AggFormComponent, {
    aggConfig: aggConfigDef.aggConfig,
    selectedField: field,
    onChange: update => {
      setAggConfigDef({
        ...aggConfigDef,
        aggConfig: update
      });
    },
    isValid: aggConfigDef.isValid()
  }) : null, isUnsupportedAgg && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "aria-label": _i18n.i18n.translate('xpack.transform.agg.popoverForm.codeBlock', {
      defaultMessage: 'JSON of transform aggregation'
    }),
    fontSize: "s",
    language: "json",
    paddingSize: "s",
    css: {
      width: '100%',
      height: '200px'
    }
  }, JSON.stringify((0, _common2.getEsAggFromAggConfig)(defaultData), null, 2)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: !formValid,
    onClick: () => onChange(getUpdatedItem()),
    "data-test-subj": "transformApplyAggChanges"
  }, _i18n.i18n.translate('xpack.transform.agg.popoverForm.submitButtonLabel', {
    defaultMessage: 'Apply'
  }))));
};
exports.PopoverForm = PopoverForm;