"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedPivotEditorSwitch = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _switch_modal = require("../switch_modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdvancedPivotEditorSwitch = ({
  advancedPivotEditor: {
    actions: {
      setAdvancedEditorSwitchModalVisible,
      toggleAdvancedEditor
    },
    state: {
      advancedEditorConfig,
      advancedEditorConfigLastApplied,
      isAdvancedEditorSwitchModalVisible,
      isAdvancedPivotEditorEnabled,
      isAdvancedPivotEditorApplyButtonEnabled
    }
  }
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorSwitchLabel', {
      defaultMessage: 'Edit JSON config'
    }),
    checked: isAdvancedPivotEditorEnabled,
    onChange: () => {
      if (isAdvancedPivotEditorEnabled && (isAdvancedPivotEditorApplyButtonEnabled || advancedEditorConfig !== advancedEditorConfigLastApplied)) {
        setAdvancedEditorSwitchModalVisible(true);
        return;
      }
      toggleAdvancedEditor();
    },
    "data-test-subj": "transformAdvancedPivotEditorSwitch"
  }), isAdvancedEditorSwitchModalVisible && /*#__PURE__*/_react.default.createElement(_switch_modal.SwitchModal, {
    onCancel: () => setAdvancedEditorSwitchModalVisible(false),
    onConfirm: () => {
      setAdvancedEditorSwitchModalVisible(false);
      toggleAdvancedEditor();
    },
    type: 'pivot'
  }))));
};
exports.AdvancedPivotEditorSwitch = AdvancedPivotEditorSwitch;