"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = mountManagementSection;
var _public = require("@kbn/kibana-utils-plugin/public");
var _shared_imports = require("../shared_imports");
var _navigation = require("./services/navigation");
var _text = require("./services/text");
var _app = require("./app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public.Storage(window.localStorage);
async function mountManagementSection(coreSetup, params) {
  const {
    element,
    setBreadcrumbs,
    history
  } = params;
  const {
    http,
    getStartServices
  } = coreSetup;
  const startServices = await getStartServices();
  const [core, plugins] = startServices;
  const {
    application,
    chrome,
    docLinks,
    i18n,
    overlays,
    theme,
    savedObjects,
    uiSettings,
    notifications
  } = core;
  const {
    data,
    dataViews,
    share,
    spaces,
    triggersActionsUi,
    unifiedSearch,
    charts,
    fieldFormats,
    savedObjectsManagement
  } = plugins;
  const {
    docTitle
  } = chrome;

  // Initialize services
  _text.textService.init();
  _navigation.docTitleService.init(docTitle.change);
  _navigation.breadcrumbService.setup(setBreadcrumbs);

  // AppCore/AppPlugins to be passed on as React context
  const appDependencies = {
    application,
    chrome,
    data,
    dataViews,
    docLinks,
    http,
    i18n,
    notifications,
    overlays,
    theme,
    savedObjects,
    storage: localStorage,
    uiSettings,
    history,
    savedObjectsPlugin: plugins.savedObjects,
    share,
    spaces,
    ml: await (0, _shared_imports.getMlSharedImports)(),
    triggersActionsUi,
    unifiedSearch,
    charts,
    fieldFormats,
    savedObjectsManagement
  };
  const unmountAppCallback = (0, _app.renderApp)(element, appDependencies);
  return () => {
    docTitle.reset();
    unmountAppCallback();
  };
}