"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthorizationProvider = exports.AuthorizationContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../../../hooks");
var _has_privilege_factory = require("../../../../../common/privilege/has_privilege_factory");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialValue = {
  isLoading: true,
  apiError: null,
  privileges: {
    hasAllPrivileges: false,
    missingPrivileges: {}
  },
  capabilities: _has_privilege_factory.INITIAL_CAPABILITIES
};
const AuthorizationContext = /*#__PURE__*/(0, _react.createContext)({
  ...initialValue
});
exports.AuthorizationContext = AuthorizationContext;
const AuthorizationProvider = ({
  privilegesEndpoint,
  children
}) => {
  const {
    isLoading,
    error,
    data: privilegesData
  } = (0, _hooks.useRequest)({
    path: privilegesEndpoint,
    method: 'get'
  });
  const value = {
    isLoading,
    privileges: isLoading ? {
      ...initialValue.privileges
    } : privilegesData.privileges,
    capabilities: isLoading ? {
      ..._has_privilege_factory.INITIAL_CAPABILITIES
    } : privilegesData.capabilities,
    apiError: error ? error : null
  };
  return /*#__PURE__*/_react.default.createElement(AuthorizationContext.Provider, {
    value: {
      ...value
    }
  }, children);
};
exports.AuthorizationProvider = AuthorizationProvider;