"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCombinedProperties = getCombinedProperties;
exports.useTransformConfigData = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _lodash = require("lodash");
var _fieldTypes = require("@kbn/field-types");
var _type_guards = require("../../../common/api_schemas/type_guards");
var _shared_imports = require("../../shared_imports");
var _errors = require("../../../common/utils/errors");
var _app_dependencies = require("../app_dependencies");
var _common = require("../common");
var _use_api = require("./use_api");
var _types = require("../sections/create_transform/components/step_define/common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function sortColumns(groupByArr) {
  return (a, b) => {
    // make sure groupBy fields are always most left columns
    if (groupByArr.some(aggName => aggName === a) && groupByArr.some(aggName => aggName === b)) {
      return a.localeCompare(b);
    }
    if (groupByArr.some(aggName => aggName === a)) {
      return -1;
    }
    if (groupByArr.some(aggName => aggName === b)) {
      return 1;
    }
    return a.localeCompare(b);
  };
}
function sortColumnsForLatest(sortField) {
  return (a, b) => {
    // make sure sort field is always the most left column
    if (sortField === a && sortField === b) {
      return a.localeCompare(b);
    }
    if (sortField === a) {
      return -1;
    }
    if (sortField === b) {
      return 1;
    }
    return a.localeCompare(b);
  };
}

/**
 * Extracts missing mappings from docs.
 */
function getCombinedProperties(populatedProperties, docs) {
  // Identify missing mappings
  const missingMappings = (0, _lodash.difference)(
  // Create an array of unique flattened field names across all docs
  [...new Set(docs.flatMap(Object.keys))], Object.keys(populatedProperties));
  return {
    ...populatedProperties,
    ...missingMappings.reduce((acc, curr) => {
      var _docs$find;
      const sampleDoc = (_docs$find = docs.find(d => typeof d[curr] !== 'undefined')) !== null && _docs$find !== void 0 ? _docs$find : {};
      acc[curr] = {
        type: typeof sampleDoc[curr]
      };
      return acc;
    }, {})
  };
}
const useTransformConfigData = (dataView, query, validationStatus, requestPayload, combinedRuntimeMappings, timeRangeMs) => {
  const [previewMappingsProperties, setPreviewMappingsProperties] = (0, _react.useState)({});
  const api = (0, _use_api.useApi)();
  const {
    ml: {
      getDataGridSchemaFromESFieldType,
      formatHumanReadableDateTimeSeconds,
      multiColumnSortFactory,
      getNestedOrEscapedVal,
      useDataGrid,
      INDEX_STATUS
    }
  } = (0, _app_dependencies.useAppDependencies)();

  // Filters mapping properties of type `object`, which get returned for nested field parents.
  const columnKeys = Object.keys(previewMappingsProperties).filter(key => previewMappingsProperties[key].type !== 'object');
  if ((0, _types.isPivotPartialRequest)(requestPayload)) {
    const groupByArr = Object.keys(requestPayload.pivot.group_by);
    columnKeys.sort(sortColumns(groupByArr));
  } else if ((0, _types.isLatestPartialRequest)(requestPayload)) {
    columnKeys.sort(sortColumnsForLatest(requestPayload.latest.sort));
  }

  // EuiDataGrid State
  const columns = columnKeys.map(id => {
    const field = previewMappingsProperties[id];
    const schema = getDataGridSchemaFromESFieldType(field === null || field === void 0 ? void 0 : field.type);
    return {
      id,
      schema
    };
  });
  const dataGrid = useDataGrid(columns);
  const {
    pagination,
    resetPagination,
    setErrorMessage,
    setNoDataMessage,
    setRowCountInfo,
    setStatus,
    setTableItems,
    sortingColumns,
    tableItems
  } = dataGrid;
  const getPreviewData = async () => {
    if (!validationStatus.isValid) {
      setTableItems([]);
      setRowCountInfo({
        rowCount: 0,
        rowCountRelation: _shared_imports.ES_CLIENT_TOTAL_HITS_RELATION.EQ
      });
      setNoDataMessage(validationStatus.errorMessage);
      return;
    }
    setErrorMessage('');
    setNoDataMessage('');
    setStatus(INDEX_STATUS.LOADING);
    const previewRequest = (0, _common.getPreviewTransformRequestBody)(dataView, query, requestPayload, combinedRuntimeMappings, timeRangeMs);
    const resp = await api.getTransformsPreview(previewRequest);
    if (!(0, _type_guards.isPostTransformsPreviewResponseSchema)(resp)) {
      setErrorMessage((0, _errors.getErrorMessage)(resp));
      setTableItems([]);
      setRowCountInfo({
        rowCount: 0,
        rowCountRelation: _shared_imports.ES_CLIENT_TOTAL_HITS_RELATION.EQ
      });
      setPreviewMappingsProperties({});
      setStatus(INDEX_STATUS.ERROR);
      return;
    }

    // To improve UI performance with a latest configuration for indices with a large number
    // of fields, we reduce the number of available columns to those populated with values.

    // 1. Flatten the returned object structure object documents to match mapping properties
    const docs = resp.preview.map(_std.getFlattenedObject);

    // 2. Get all field names for each returned doc and flatten it
    //    to a list of unique field names used across all docs.
    const populatedFields = [...new Set(docs.map(Object.keys).flat(1))];

    // 3. Filter mapping properties by populated fields
    let populatedProperties = Object.entries(resp.generated_dest_index.mappings.properties).filter(([key]) => populatedFields.includes(key)).reduce((p, [key, value]) => ({
      ...p,
      [key]: value
    }), {});
    populatedProperties = getCombinedProperties(populatedProperties, docs);
    setTableItems(docs);
    setRowCountInfo({
      rowCount: docs.length,
      rowCountRelation: _shared_imports.ES_CLIENT_TOTAL_HITS_RELATION.EQ
    });
    setPreviewMappingsProperties(populatedProperties);
    setStatus(INDEX_STATUS.LOADED);
    if (docs.length === 0) {
      setNoDataMessage(_i18n.i18n.translate('xpack.transform.pivotPreview.PivotPreviewNoDataCalloutBody', {
        defaultMessage: 'The preview request did not return any data. Please ensure the optional query returns data and that values exist for the field used by group-by and aggregation fields.'
      }));
    }
  };
  (0, _react.useEffect)(() => {
    resetPagination();
    // custom comparison
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(query)]);
  (0, _react.useEffect)(() => {
    getPreviewData();
    // custom comparison
    /* eslint-disable react-hooks/exhaustive-deps */
  }, [dataView.getIndexPattern(), JSON.stringify([requestPayload, query, combinedRuntimeMappings, timeRangeMs])]);
  if (sortingColumns.length > 0) {
    const sortingColumnsWithTypes = sortingColumns.map(c => ({
      ...c,
      // Since items might contain undefined/null values, we want to accurate find the data type
      type: typeof tableItems.find(item => getNestedOrEscapedVal(item, c.id) !== undefined)
    }));
    tableItems.sort(multiColumnSortFactory(sortingColumnsWithTypes));
  }
  const pageData = tableItems.slice(pagination.pageIndex * pagination.pageSize, (pagination.pageIndex + 1) * pagination.pageSize);
  const renderCellValue = (0, _react.useMemo)(() => {
    return ({
      rowIndex,
      columnId
    }) => {
      var _pageData$adjustedRow;
      const adjustedRowIndex = rowIndex - pagination.pageIndex * pagination.pageSize;
      const cellValue = pageData.hasOwnProperty(adjustedRowIndex) ? (_pageData$adjustedRow = pageData[adjustedRowIndex][columnId]) !== null && _pageData$adjustedRow !== void 0 ? _pageData$adjustedRow : null : null;
      if (typeof cellValue === 'object' && cellValue !== null) {
        return JSON.stringify(cellValue);
      }
      if (cellValue === undefined || cellValue === null) {
        return null;
      }
      if ([_fieldTypes.ES_FIELD_TYPES.DATE, _fieldTypes.ES_FIELD_TYPES.DATE_NANOS].includes(previewMappingsProperties[columnId].type)) {
        return formatHumanReadableDateTimeSeconds((0, _momentTimezone.default)(cellValue).unix() * 1000);
      }
      if (previewMappingsProperties[columnId].type === _fieldTypes.ES_FIELD_TYPES.BOOLEAN) {
        return cellValue ? 'true' : 'false';
      }
      return cellValue;
    };
  }, [pageData, pagination.pageIndex, pagination.pageSize, previewMappingsProperties, formatHumanReadableDateTimeSeconds]);
  return {
    ...dataGrid,
    chartsButtonVisible: false,
    renderCellValue
  };
};
exports.useTransformConfigData = useTransformConfigData;