"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReauthorizeTransforms = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _type_guards = require("../../../common/api_schemas/type_guards");
var _errors = require("../../../common/utils/errors");
var _app_dependencies = require("../app_dependencies");
var _common = require("../common");
var _components = require("../components");
var _use_api = require("./use_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useReauthorizeTransforms = () => {
  const {
    overlays,
    theme
  } = (0, _app_dependencies.useAppDependencies)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const api = (0, _use_api.useApi)();
  return async transformsInfo => {
    const results = await api.reauthorizeTransforms(transformsInfo);
    if (!(0, _type_guards.isStartTransformsResponseSchema)(results)) {
      toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.transform.stepCreateForm.reauthorizeTransformResponseSchemaErrorMessage', {
          defaultMessage: 'An error occurred calling the reauthorize transforms request.'
        }),
        text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
          overlays: overlays,
          theme: theme,
          text: (0, _errors.getErrorMessage)(results)
        }), {
          theme$: theme.theme$
        })
      });
      return;
    }
    for (const transformId in results) {
      // hasOwnProperty check to ensure only properties on object itself, and not its prototypes
      if (results.hasOwnProperty(transformId)) {
        const result = results[transformId];
        if (result.success === true) {
          toastNotifications.addSuccess(_i18n.i18n.translate('xpack.transform.transformList.reauthorizeTransformSuccessMessage', {
            defaultMessage: 'Request to reauthorize transform {transformId} acknowledged.',
            values: {
              transformId
            }
          }));
        } else {
          toastNotifications.addError(new Error(JSON.stringify(result.error.caused_by, null, 2)), {
            title: _i18n.i18n.translate('xpack.transform.transformList.reauthorizeTransformErrorMessage', {
              defaultMessage: 'An error occurred reauthorizing the transform {transformId}',
              values: {
                transformId
              }
            }),
            toastMessage: result.error.reason
          });
        }
      }
    }
    _common.refreshTransformList$.next(_common.REFRESH_TRANSFORM_LIST_STATE.REFRESH);
  };
};
exports.useReauthorizeTransforms = useReauthorizeTransforms;