"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useApi = exports.DEFAULT_SAMPLER_SHARD_SIZE = void 0;
var _react = require("react");
var _constants = require("../../../common/constants");
var _app_dependencies = require("../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Default sampler shard size used for field histograms
const DEFAULT_SAMPLER_SHARD_SIZE = 5000;
exports.DEFAULT_SAMPLER_SHARD_SIZE = DEFAULT_SAMPLER_SHARD_SIZE;
const useApi = () => {
  const {
    http
  } = (0, _app_dependencies.useAppDependencies)();
  return (0, _react.useMemo)(() => ({
    async getTransformNodes() {
      try {
        return await http.get(`${_constants.API_BASE_PATH}transforms/_nodes`);
      } catch (e) {
        return e;
      }
    },
    async getTransform(transformId) {
      try {
        return await http.get(`${_constants.API_BASE_PATH}transforms/${transformId}`);
      } catch (e) {
        return e;
      }
    },
    async getTransforms(fetchOptions = {}) {
      try {
        return await http.get(`${_constants.API_BASE_PATH}transforms`, fetchOptions);
      } catch (e) {
        return e;
      }
    },
    async getTransformStats(transformId) {
      try {
        return await http.get(`${_constants.API_BASE_PATH}transforms/${transformId}/_stats`);
      } catch (e) {
        return e;
      }
    },
    async getTransformsStats(fetchOptions = {}) {
      try {
        return await http.get(`${_constants.API_BASE_PATH}transforms/_stats`, fetchOptions);
      } catch (e) {
        return e;
      }
    },
    async createTransform(transformId, transformConfig) {
      try {
        return await http.put(`${_constants.API_BASE_PATH}transforms/${transformId}`, {
          body: JSON.stringify(transformConfig)
        });
      } catch (e) {
        return e;
      }
    },
    async updateTransform(transformId, transformConfig) {
      try {
        return await http.post(`${_constants.API_BASE_PATH}transforms/${transformId}/_update`, {
          body: JSON.stringify(transformConfig)
        });
      } catch (e) {
        return e;
      }
    },
    async deleteTransforms(reqBody) {
      try {
        return await http.post(`${_constants.API_BASE_PATH}delete_transforms`, {
          body: JSON.stringify(reqBody)
        });
      } catch (e) {
        return e;
      }
    },
    async getTransformsPreview(obj) {
      try {
        return await http.post(`${_constants.API_BASE_PATH}transforms/_preview`, {
          body: JSON.stringify(obj)
        });
      } catch (e) {
        return e;
      }
    },
    async reauthorizeTransforms(reqBody) {
      try {
        return await http.post(`${_constants.API_BASE_PATH}reauthorize_transforms`, {
          body: JSON.stringify(reqBody)
        });
      } catch (e) {
        return e;
      }
    },
    async resetTransforms(reqBody) {
      try {
        return await http.post(`${_constants.API_BASE_PATH}reset_transforms`, {
          body: JSON.stringify(reqBody)
        });
      } catch (e) {
        return e;
      }
    },
    async startTransforms(reqBody) {
      try {
        return await http.post(`${_constants.API_BASE_PATH}start_transforms`, {
          body: JSON.stringify(reqBody)
        });
      } catch (e) {
        return e;
      }
    },
    async stopTransforms(transformsInfo) {
      try {
        return await http.post(`${_constants.API_BASE_PATH}stop_transforms`, {
          body: JSON.stringify(transformsInfo)
        });
      } catch (e) {
        return e;
      }
    },
    async scheduleNowTransforms(transformsInfo) {
      try {
        return await http.post(`${_constants.API_BASE_PATH}schedule_now_transforms`, {
          body: JSON.stringify(transformsInfo)
        });
      } catch (e) {
        return e;
      }
    },
    async getTransformAuditMessages(transformId, sortField, sortDirection) {
      try {
        return await http.get(`${_constants.API_BASE_PATH}transforms/${transformId}/messages`, {
          query: {
            sortField,
            sortDirection
          }
        });
      } catch (e) {
        return e;
      }
    },
    async getEsIndices() {
      try {
        return await http.get(`/api/index_management/indices`);
      } catch (e) {
        return e;
      }
    },
    async getEsIngestPipelines() {
      try {
        return await http.get('/api/ingest_pipelines');
      } catch (e) {
        return e;
      }
    },
    async getHistogramsForFields(dataViewTitle, fields, query, runtimeMappings, samplerShardSize = DEFAULT_SAMPLER_SHARD_SIZE) {
      try {
        return await http.post(`${_constants.API_BASE_PATH}field_histograms/${dataViewTitle}`, {
          body: JSON.stringify({
            query,
            fields,
            samplerShardSize,
            ...(runtimeMappings !== undefined ? {
              runtimeMappings
            } : {})
          })
        });
      } catch (e) {
        return e;
      }
    }
  }), [http]);
};
exports.useApi = useApi;