"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SectionError = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SectionError = ({
  title,
  error,
  actions,
  ...rest
}) => {
  var _error$message;
  const errorMessage = (_error$message = error === null || error === void 0 ? void 0 : error.message) !== null && _error$message !== void 0 ? _error$message : JSON.stringify(error, null, 2);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
    verticalPosition: "center",
    horizontalPosition: "center",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h2", null, title),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("pre", null, errorMessage), actions ? actions : null)
  }));
};
exports.SectionError = SectionError;