"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultQuery = void 0;
exports.getCombinedRuntimeMappings = getCombinedRuntimeMappings;
exports.getMissingBucketConfig = exports.getCreateTransformSettingsRequestBody = exports.getCreateTransformRequestBody = void 0;
exports.getPreviewTransformRequestBody = getPreviewTransformRequestBody;
exports.getRequestPayload = void 0;
exports.getTransformConfigQuery = getTransformConfigQuery;
exports.isDefaultQuery = isDefaultQuery;
exports.isFilterBasedSimpleQuery = isFilterBasedSimpleQuery;
exports.isMatchAllQuery = isMatchAllQuery;
exports.isSimpleQuery = isSimpleQuery;
exports.matchAllQuery = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _constants = require("../../../common/constants");
var _data_view = require("../../../common/types/data_view");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTransformConfigQuery(search) {
  if (typeof search === 'string') {
    return {
      query_string: {
        query: search,
        default_operator: 'AND'
      }
    };
  }
  return search;
}
function isSimpleQuery(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['query_string']);
}
function isFilterBasedSimpleQuery(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['bool']) && (0, _mlIsPopulatedObject.isPopulatedObject)(arg.bool, ['filter']) && Array.isArray(arg.bool.filter) && arg.bool.filter.length === 1 && isSimpleQuery(arg.bool.filter[0]);
}
const matchAllQuery = {
  match_all: {}
};
exports.matchAllQuery = matchAllQuery;
function isMatchAllQuery(query) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(query, ['match_all']) && typeof query.match_all === 'object' && query.match_all !== null && Object.keys(query.match_all).length === 0;
}
const defaultQuery = {
  query_string: {
    query: '*'
  }
};
exports.defaultQuery = defaultQuery;
function isDefaultQuery(query) {
  return isMatchAllQuery(query) || isSimpleQuery(query) && query.query_string.query === '*' || isFilterBasedSimpleQuery(query) && (query.bool.filter[0].query_string.query === '*' || isMatchAllQuery(query.bool.filter[0]));
}
function getCombinedRuntimeMappings(dataView, runtimeMappings) {
  let combinedRuntimeMappings = {};

  // And runtime field mappings defined by index pattern
  if ((0, _data_view.isDataView)(dataView)) {
    const computedFields = dataView.getComputedFields();
    if ((computedFields === null || computedFields === void 0 ? void 0 : computedFields.runtimeFields) !== undefined) {
      const ipRuntimeMappings = computedFields.runtimeFields;
      if ((0, _mlIsPopulatedObject.isPopulatedObject)(ipRuntimeMappings)) {
        combinedRuntimeMappings = {
          ...combinedRuntimeMappings,
          ...ipRuntimeMappings
        };
      }
    }
  }

  // Use runtime field mappings defined inline from API
  // and override fields with same name from index pattern
  if ((0, _mlIsPopulatedObject.isPopulatedObject)(runtimeMappings)) {
    combinedRuntimeMappings = {
      ...combinedRuntimeMappings,
      ...runtimeMappings
    };
  }
  if ((0, _mlIsPopulatedObject.isPopulatedObject)(combinedRuntimeMappings)) {
    return combinedRuntimeMappings;
  }
  return undefined;
}
const getMissingBucketConfig = g => {
  return g.missing_bucket !== undefined ? {
    missing_bucket: g.missing_bucket
  } : {};
};
exports.getMissingBucketConfig = getMissingBucketConfig;
const getRequestPayload = (pivotAggsArr, pivotGroupByArr) => {
  const request = {
    pivot: {
      group_by: {},
      aggregations: {}
    }
  };
  pivotGroupByArr.forEach(g => {
    if ((0, _.isGroupByTerms)(g)) {
      const termsAgg = {
        terms: {
          field: g.field,
          ...getMissingBucketConfig(g)
        }
      };
      request.pivot.group_by[g.aggName] = termsAgg;
    } else if ((0, _.isGroupByHistogram)(g)) {
      const histogramAgg = {
        histogram: {
          field: g.field,
          interval: g.interval,
          ...getMissingBucketConfig(g)
        }
      };
      request.pivot.group_by[g.aggName] = histogramAgg;
    } else if ((0, _.isGroupByDateHistogram)(g)) {
      const dateHistogramAgg = {
        date_histogram: {
          field: g.field,
          calendar_interval: g.calendar_interval,
          time_zone: g.time_zone,
          ...getMissingBucketConfig(g)
        }
      };
      request.pivot.group_by[g.aggName] = dateHistogramAgg;
    } else {
      request.pivot.group_by[g.aggName] = (0, _.getEsAggFromGroupByConfig)(g);
    }
  });
  pivotAggsArr.forEach(agg => {
    const result = (0, _.getEsAggFromAggConfig)(agg);
    if (result === null) {
      return;
    }
    request.pivot.aggregations[agg.aggName] = result;
  });
  return request;
};
exports.getRequestPayload = getRequestPayload;
function getPreviewTransformRequestBody(dataView, transformConfigQuery, partialRequest, runtimeMappings, timeRangeMs) {
  const dataViewTitle = dataView.getIndexPattern();
  const index = dataViewTitle.split(',').map(name => name.trim());
  const hasValidTimeField = dataView.timeFieldName !== undefined && dataView.timeFieldName !== '';
  const baseFilterCriteria = (0, _mlQueryUtils.buildBaseFilterCriteria)(dataView.timeFieldName, timeRangeMs === null || timeRangeMs === void 0 ? void 0 : timeRangeMs.from, timeRangeMs === null || timeRangeMs === void 0 ? void 0 : timeRangeMs.to, isDefaultQuery(transformConfigQuery) ? undefined : transformConfigQuery);
  const queryWithBaseFilterCriteria = {
    bool: {
      filter: baseFilterCriteria
    }
  };
  const query = hasValidTimeField && baseFilterCriteria.length > 0 ? queryWithBaseFilterCriteria : transformConfigQuery;
  return {
    source: {
      index,
      ...(isDefaultQuery(query) ? {} : {
        query
      }),
      ...((0, _mlIsPopulatedObject.isPopulatedObject)(runtimeMappings) ? {
        runtime_mappings: runtimeMappings
      } : {})
    },
    ...(partialRequest !== null && partialRequest !== void 0 ? partialRequest : {})
  };
}
const getCreateTransformSettingsRequestBody = transformDetailsState => {
  const settings = {
    // conditionally add optional max_page_search_size, skip if default value
    ...(transformDetailsState.transformSettingsMaxPageSearchSize && transformDetailsState.transformSettingsMaxPageSearchSize !== _constants.DEFAULT_TRANSFORM_SETTINGS_MAX_PAGE_SEARCH_SIZE ? {
      max_page_search_size: transformDetailsState.transformSettingsMaxPageSearchSize
    } : {}),
    // conditionally add optional docs_per_second, skip if default value
    ...(transformDetailsState.transformSettingsDocsPerSecond && transformDetailsState.transformSettingsDocsPerSecond !== _constants.DEFAULT_TRANSFORM_SETTINGS_DOCS_PER_SECOND ? {
      docs_per_second: transformDetailsState.transformSettingsDocsPerSecond
    } : {}),
    ...(typeof transformDetailsState.transformSettingsNumFailureRetries === 'number' ? {
      num_failure_retries: transformDetailsState.transformSettingsNumFailureRetries
    } : {})
  };
  return Object.keys(settings).length > 0 ? {
    settings
  } : {};
};
exports.getCreateTransformSettingsRequestBody = getCreateTransformSettingsRequestBody;
const getCreateTransformRequestBody = (dataView, transformConfigState, transformDetailsState) => ({
  ...getPreviewTransformRequestBody(dataView, getTransformConfigQuery(transformConfigState.searchQuery), transformConfigState.previewRequest, transformConfigState.runtimeMappings, transformConfigState.isDatePickerApplyEnabled && transformConfigState.timeRangeMs ? transformConfigState.timeRangeMs : undefined),
  // conditionally add optional description
  ...(transformDetailsState.transformDescription !== '' ? {
    description: transformDetailsState.transformDescription
  } : {}),
  // conditionally add optional frequency, skip if default value
  ...(transformDetailsState.transformFrequency !== '' && transformDetailsState.transformFrequency !== _constants.DEFAULT_TRANSFORM_FREQUENCY ? {
    frequency: transformDetailsState.transformFrequency
  } : {}),
  dest: {
    index: transformDetailsState.destinationIndex,
    // conditionally add optional ingest pipeline
    ...(transformDetailsState.destinationIngestPipeline !== '' ? {
      pipeline: transformDetailsState.destinationIngestPipeline
    } : {})
  },
  // conditionally add continuous mode config
  ...(transformDetailsState.isContinuousModeEnabled ? {
    sync: {
      time: {
        // conditionally add continuous mode delay, skip if default value
        ...(transformDetailsState.continuousModeDelay !== _constants.DEFAULT_CONTINUOUS_MODE_DELAY ? {
          delay: transformDetailsState.continuousModeDelay
        } : {}),
        field: transformDetailsState.continuousModeDateField
      }
    }
  } : {}),
  // conditionally add retention policy settings
  ...(transformDetailsState.isRetentionPolicyEnabled ? {
    retention_policy: {
      time: {
        field: transformDetailsState.retentionPolicyDateField,
        max_age: transformDetailsState.retentionPolicyMaxAge
      }
    }
  } : {}),
  ...(transformDetailsState._meta ? {
    _meta: transformDetailsState._meta
  } : {}),
  // conditionally add additional settings
  ...getCreateTransformSettingsRequestBody(transformDetailsState)
});
exports.getCreateTransformRequestBody = getCreateTransformRequestBody;