"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOP_METRICS_SPECIAL_SORT_FIELDS = exports.TOP_METRICS_SORT_FIELD_TYPES = exports.TERMS_AGG_DEFAULT_SIZE = exports.SORT_MODE = exports.SORT_DIRECTION = exports.PERCENTILES_AGG_DEFAULT_PERCENTS = exports.NUMERIC_TYPES_OPTIONS = exports.MAX_NESTING_SUB_AGGS = void 0;
exports.getAggConfigFromEsAgg = getAggConfigFromEsAgg;
exports.getEsAggFromAggConfig = getEsAggFromAggConfig;
exports.isPivotAggConfigTopMetric = isPivotAggConfigTopMetric;
exports.isPivotAggsConfigPercentiles = isPivotAggsConfigPercentiles;
exports.isPivotAggsConfigTerms = isPivotAggsConfigTerms;
exports.isPivotAggsConfigWithUiBase = isPivotAggsConfigWithUiBase;
exports.isPivotAggsWithExtendedForm = isPivotAggsWithExtendedForm;
exports.isPivotSupportedAggs = isPivotSupportedAggs;
exports.pivotAggsFieldSupport = exports.isValidSortNumericType = exports.isValidSortMode = exports.isValidSortDirection = exports.isSpecialSortField = void 0;
var _fieldTypes = require("@kbn/field-types");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _pivot_aggs = require("../../../common/types/pivot_aggs");
var _get_agg_form_config = require("../sections/create_transform/components/step_define/common/get_agg_form_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isPivotSupportedAggs(arg) {
  return typeof arg === 'string' && Object.values(_pivot_aggs.PIVOT_SUPPORTED_AGGS).includes(arg);
}
const PERCENTILES_AGG_DEFAULT_PERCENTS = [1, 5, 25, 50, 75, 95, 99];
exports.PERCENTILES_AGG_DEFAULT_PERCENTS = PERCENTILES_AGG_DEFAULT_PERCENTS;
const TERMS_AGG_DEFAULT_SIZE = 10;
exports.TERMS_AGG_DEFAULT_SIZE = TERMS_AGG_DEFAULT_SIZE;
const pivotAggsFieldSupport = {
  [_fieldTypes.KBN_FIELD_TYPES.ATTACHMENT]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.VALUE_COUNT, _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER],
  [_fieldTypes.KBN_FIELD_TYPES.BOOLEAN]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.VALUE_COUNT, _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER, _pivot_aggs.PIVOT_SUPPORTED_AGGS.TERMS],
  [_fieldTypes.KBN_FIELD_TYPES.DATE]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.MAX, _pivot_aggs.PIVOT_SUPPORTED_AGGS.MIN, _pivot_aggs.PIVOT_SUPPORTED_AGGS.VALUE_COUNT, _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER],
  [_fieldTypes.KBN_FIELD_TYPES.GEO_POINT]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.VALUE_COUNT, _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER],
  [_fieldTypes.KBN_FIELD_TYPES.GEO_SHAPE]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.VALUE_COUNT, _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER],
  [_fieldTypes.KBN_FIELD_TYPES.IP]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.CARDINALITY, _pivot_aggs.PIVOT_SUPPORTED_AGGS.VALUE_COUNT, _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER, _pivot_aggs.PIVOT_SUPPORTED_AGGS.TOP_METRICS, _pivot_aggs.PIVOT_SUPPORTED_AGGS.TERMS],
  [_fieldTypes.KBN_FIELD_TYPES.MURMUR3]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.VALUE_COUNT, _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER],
  [_fieldTypes.KBN_FIELD_TYPES.NUMBER]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.AVG, _pivot_aggs.PIVOT_SUPPORTED_AGGS.CARDINALITY, _pivot_aggs.PIVOT_SUPPORTED_AGGS.MAX, _pivot_aggs.PIVOT_SUPPORTED_AGGS.MIN, _pivot_aggs.PIVOT_SUPPORTED_AGGS.PERCENTILES, _pivot_aggs.PIVOT_SUPPORTED_AGGS.SUM, _pivot_aggs.PIVOT_SUPPORTED_AGGS.VALUE_COUNT, _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER, _pivot_aggs.PIVOT_SUPPORTED_AGGS.TERMS, _pivot_aggs.PIVOT_SUPPORTED_AGGS.TOP_METRICS],
  [_fieldTypes.KBN_FIELD_TYPES.STRING]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.CARDINALITY, _pivot_aggs.PIVOT_SUPPORTED_AGGS.VALUE_COUNT, _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER, _pivot_aggs.PIVOT_SUPPORTED_AGGS.TOP_METRICS, _pivot_aggs.PIVOT_SUPPORTED_AGGS.TERMS],
  [_fieldTypes.KBN_FIELD_TYPES._SOURCE]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.VALUE_COUNT, _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER],
  [_fieldTypes.KBN_FIELD_TYPES.UNKNOWN]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.VALUE_COUNT, _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER],
  [_fieldTypes.KBN_FIELD_TYPES.CONFLICT]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.VALUE_COUNT, _pivot_aggs.PIVOT_SUPPORTED_AGGS.FILTER],
  [_mlAggUtils.TIME_SERIES_METRIC_TYPES.COUNTER]: [_pivot_aggs.PIVOT_SUPPORTED_AGGS.MAX, _pivot_aggs.PIVOT_SUPPORTED_AGGS.MIN, _pivot_aggs.PIVOT_SUPPORTED_AGGS.TOP_METRICS]
};
exports.pivotAggsFieldSupport = pivotAggsFieldSupport;
const TOP_METRICS_SORT_FIELD_TYPES = [_fieldTypes.KBN_FIELD_TYPES.NUMBER, _fieldTypes.KBN_FIELD_TYPES.DATE, _fieldTypes.KBN_FIELD_TYPES.GEO_POINT, _mlAggUtils.TIME_SERIES_METRIC_TYPES.COUNTER];
exports.TOP_METRICS_SORT_FIELD_TYPES = TOP_METRICS_SORT_FIELD_TYPES;
const SORT_DIRECTION = {
  ASC: 'asc',
  DESC: 'desc'
};
exports.SORT_DIRECTION = SORT_DIRECTION;
const SORT_MODE = {
  MIN: 'min',
  MAX: 'max',
  AVG: 'avg',
  SUM: 'sum',
  MEDIAN: 'median'
};
exports.SORT_MODE = SORT_MODE;
const NUMERIC_TYPES_OPTIONS = {
  [_fieldTypes.KBN_FIELD_TYPES.NUMBER]: [_fieldTypes.ES_FIELD_TYPES.DOUBLE, _fieldTypes.ES_FIELD_TYPES.LONG],
  [_fieldTypes.KBN_FIELD_TYPES.DATE]: [_fieldTypes.ES_FIELD_TYPES.DATE, _fieldTypes.ES_FIELD_TYPES.DATE_NANOS]
};
exports.NUMERIC_TYPES_OPTIONS = NUMERIC_TYPES_OPTIONS;
const SORT_NUMERIC_FIELD_TYPES = [_fieldTypes.ES_FIELD_TYPES.DOUBLE, _fieldTypes.ES_FIELD_TYPES.LONG, _fieldTypes.ES_FIELD_TYPES.DATE, _fieldTypes.ES_FIELD_TYPES.DATE_NANOS];
const TOP_METRICS_SPECIAL_SORT_FIELDS = {
  _SCORE: '_score'
};
exports.TOP_METRICS_SPECIAL_SORT_FIELDS = TOP_METRICS_SPECIAL_SORT_FIELDS;
const isSpecialSortField = sortField => {
  return Object.values(TOP_METRICS_SPECIAL_SORT_FIELDS).some(v => v === sortField);
};
exports.isSpecialSortField = isSpecialSortField;
const isValidSortDirection = arg => {
  return Object.values(SORT_DIRECTION).some(v => v === arg);
};
exports.isValidSortDirection = isValidSortDirection;
const isValidSortMode = arg => {
  return Object.values(SORT_MODE).some(v => v === arg);
};
exports.isValidSortMode = isValidSortMode;
const isValidSortNumericType = arg => {
  return SORT_NUMERIC_FIELD_TYPES.some(v => v === arg);
};

/**
 * The maximum level of sub-aggregations
 */
exports.isValidSortNumericType = isValidSortNumericType;
const MAX_NESTING_SUB_AGGS = 10;

// The internal representation of an aggregation definition.
exports.MAX_NESTING_SUB_AGGS = MAX_NESTING_SUB_AGGS;
/**
 * Resolves agg UI config from provided ES agg definition
 */
function getAggConfigFromEsAgg(esAggDefinition, aggName, parentRef) {
  const aggKeys = Object.keys(esAggDefinition);

  // Find the main aggregation key
  const agg = aggKeys.find(aggKey => aggKey !== 'aggs');
  if (agg === undefined) {
    throw new Error(`Aggregation key is required`);
  }
  const commonConfig = {
    // FIXME this spread operator set the field property
    // Check if there are some extra props involved
    ...esAggDefinition[agg],
    agg,
    aggName,
    dropDownName: aggName
  };
  const config = (0, _get_agg_form_config.getAggFormConfig)(agg, commonConfig);
  if (parentRef) {
    config.parentAgg = parentRef;
  }
  if (isPivotAggsWithExtendedForm(config)) {
    config.setUiConfigFromEs(esAggDefinition[agg]);
  }
  if (aggKeys.includes('aggs')) {
    config.subAggs = {};
    for (const [subAggName, subAggConfigs] of Object.entries(esAggDefinition.aggs)) {
      config.subAggs[subAggName] = getAggConfigFromEsAgg(subAggConfigs, subAggName, config);
    }
  }
  return config;
}
function isPivotAggsConfigWithUiBase(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['agg', 'aggName', 'dropDownName', 'field']) && isPivotSupportedAggs(arg.agg);
}

/**
 * Union type for agg configs with extended forms
 */

function isPivotAggsWithExtendedForm(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['setUiConfigFromEs']) || (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['AggFormComponent']);
}
function isPivotAggConfigTopMetric(arg) {
  return isPivotAggsWithExtendedForm(arg) && arg.agg === _pivot_aggs.PIVOT_SUPPORTED_AGGS.TOP_METRICS;
}
function isPivotAggsConfigPercentiles(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['agg', 'field', 'percents']) && arg.agg === _pivot_aggs.PIVOT_SUPPORTED_AGGS.PERCENTILES;
}
function isPivotAggsConfigTerms(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['agg', 'field', 'size']) && arg.agg === _pivot_aggs.PIVOT_SUPPORTED_AGGS.TERMS;
}
/**
 * Extracts Elasticsearch-ready aggregation configuration
 * from the UI config
 */
function getEsAggFromAggConfig(pivotAggsConfig) {
  let esAgg = {
    ...pivotAggsConfig
  };
  delete esAgg.agg;
  delete esAgg.aggName;
  delete esAgg.dropDownName;
  delete esAgg.parentAgg;
  if (isPivotAggsWithExtendedForm(pivotAggsConfig)) {
    esAgg = pivotAggsConfig.getEsAggConfig();
    if (esAgg === null) {
      return null;
    }
  }
  const result = {
    [pivotAggsConfig.agg]: esAgg
  };
  if (isPivotAggsConfigWithUiBase(pivotAggsConfig) && pivotAggsConfig.subAggs !== undefined && Object.keys(pivotAggsConfig.subAggs).length > 0) {
    result.aggs = {};
    for (const subAggConfig of Object.values(pivotAggsConfig.subAggs)) {
      result.aggs[subAggConfig.aggName] = getEsAggFromAggConfig(subAggConfig);
    }
  }
  return result;
}