"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAggName = isAggName;
var _shared_imports = require("../../../common/shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isAggName(arg) {
  // allow all characters except `[]>` and must not start or end with a space.
  const validatorFn = (0, _shared_imports.composeValidators)((0, _shared_imports.patternValidator)(/^[^\s]/), (0, _shared_imports.patternValidator)(/[^\s]$/), (0, _shared_imports.patternValidator)(/^[^\[\]>]+$/));
  return validatorFn(arg) === null;
}