"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelinesPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _methods = require("./methods");
var _use_add_to_timeline = require("./hooks/use_add_to_timeline");
var _hover_actions = require("./components/hover_actions");
var _reducer = require("./store/timeline/reducer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TimelinesPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "_store", void 0);
    (0, _defineProperty2.default)(this, "_storeUnsubscribe", void 0);
    (0, _defineProperty2.default)(this, "_hoverActions", void 0);
  }
  setup(core) {}
  start(core, {
    data
  }) {
    return {
      /** `getHoverActions` returns a new reference to `getAddToTimelineButton` each time it is called, but that value is used in dependency arrays and so it should be as stable as possible. Therefore we lazily store the reference to it. Note: this reference is deleted when the store is changed. */
      getHoverActions: () => {
        if (this._hoverActions) {
          return this._hoverActions;
        } else {
          this._hoverActions = (0, _hover_actions.getHoverActions)(this._store);
          return this._hoverActions;
        }
      },
      getTimelineReducer: () => {
        return _reducer.timelineReducer;
      },
      getLoadingPanel: props => {
        return (0, _methods.getLoadingPanelLazy)(props);
      },
      getLastUpdated: props => {
        return (0, _methods.getLastUpdatedLazy)(props);
      },
      getUseAddToTimeline: () => {
        return _use_add_to_timeline.useAddToTimeline;
      },
      getUseAddToTimelineSensor: () => {
        return _use_add_to_timeline.useAddToTimelineSensor;
      },
      setTimelineEmbeddedStore: store => {
        this.setStore(store);
      }
    };
  }
  setStore(store) {
    this._store = store;
    // this is lazily calculated and that is dependent on the store
    delete this._hoverActions;
  }
  stop() {
    if (this._storeUnsubscribe) {
      this._storeUnsubscribe();
    }
  }
}
exports.TimelinesPlugin = TimelinesPlugin;