"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockHoverActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mockHoverActions = {
  getAddToTimelineButton: () => /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "test-add-to-timeline"
  }, 'Add To Timeline'),
  getColumnToggleButton: () => /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "test-column-toggle"
  }, 'Column Toggle'),
  getCopyButton: () => /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "test-copy-button"
  }, 'Copy button'),
  getFilterForValueButton: () => /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "test-filter-for"
  }, 'Filter button'),
  getFilterOutValueButton: () => /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "test-filter-out"
  }, 'Filter out button'),
  getOverflowButton: props => /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    "data-test-subj": `more-actions-${props.field}`
  }, props), 'Overflow button')
};
exports.mockHoverActions = mockHoverActions;