"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FIELD = exports.COPY_TO_CLIPBOARD_KEYBOARD_SHORTCUT = exports.COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME = void 0;
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _accessibility = require("../../../../common/utils/accessibility");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var _translations = require("./translations");
var _with_copy_to_clipboard = require("../../clipboard/with_copy_to_clipboard");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD = _i18n.i18n.translate('xpack.timelines.hoverActions.fieldLabel', {
  defaultMessage: 'Field'
});
exports.FIELD = FIELD;
const COPY_TO_CLIPBOARD_KEYBOARD_SHORTCUT = 'c';
exports.COPY_TO_CLIPBOARD_KEYBOARD_SHORTCUT = COPY_TO_CLIPBOARD_KEYBOARD_SHORTCUT;
const COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME = 'copy-to-clipboard';
exports.COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME = COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME;
const CopyButton = /*#__PURE__*/_react.default.memo(({
  Component,
  field,
  isHoverAction,
  onClick,
  keyboardEvent,
  ownFocus,
  value
}) => {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const panelRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (!ownFocus) {
      return;
    }
    if ((keyboardEvent === null || keyboardEvent === void 0 ? void 0 : keyboardEvent.key) === COPY_TO_CLIPBOARD_KEYBOARD_SHORTCUT) {
      var _panelRef$current;
      (0, _accessibility.stopPropagationAndPreventDefault)(keyboardEvent);
      const copyToClipboardButton = (_panelRef$current = panelRef.current) === null || _panelRef$current === void 0 ? void 0 : _panelRef$current.querySelector(`.${COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME}`);
      if (copyToClipboardButton != null) {
        copyToClipboardButton.click();
      }
      if (onClick != null) {
        onClick();
      }
    }
  }, [onClick, keyboardEvent, ownFocus]);
  const text = (0, _react.useMemo)(() => `${field}${value != null ? `: "${value}"` : ''}`, [field, value]);
  const handleOnClick = (0, _react.useCallback)(() => {
    const isSuccess = (0, _copyToClipboard.default)(text, {
      debug: true
    });
    if (onClick != null) {
      onClick();
    }
    if (isSuccess) {
      addSuccess((0, _translations.SUCCESS_TOAST_TITLE)(field), {
        toastLifeTimeMs: 800
      });
    }
  }, [addSuccess, field, onClick, text]);
  return Component ? /*#__PURE__*/_react.default.createElement(Component, {
    "aria-label": _translations.COPY_TO_CLIPBOARD,
    "data-test-subj": "copy-to-clipboard",
    icon: "copy",
    iconType: "copy",
    onClick: handleOnClick,
    title: _translations.COPY_TO_CLIPBOARD
  }, _translations.COPY_TO_CLIPBOARD) : /*#__PURE__*/_react.default.createElement("div", {
    ref: panelRef
  }, /*#__PURE__*/_react.default.createElement(_with_copy_to_clipboard.WithCopyToClipboard, {
    "data-test-subj": "copy-to-clipboard",
    isHoverAction: isHoverAction,
    keyboardShortcut: ownFocus ? COPY_TO_CLIPBOARD_KEYBOARD_SHORTCUT : '',
    text: text,
    titleSummary: FIELD
  }));
});
exports.default = CopyButton;
CopyButton.displayName = 'CopyButton';

// eslint-disable-next-line import/no-default-export