"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createApp = exports.ThreatIntelligencePlugin = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("./modules/cases/utils");
var _use_kibana = require("./hooks/use_kibana");
var _security_solution_context = require("./containers/security_solution_context");
var _enterprise_guard = require("./containers/enterprise_guard");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const LazyIndicatorsPageWrapper = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./containers/indicators_page_wrapper'))));

/**
 * This is used here:
 * x-pack/plugins/security_solution/public/threat_intelligence/routes.tsx
 */
const createApp = services => () => ({
  securitySolutionContext
}) => /*#__PURE__*/_react.default.createElement(_i18nReact.__IntlProvider, null, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
  store: securitySolutionContext.securitySolutionStore
}, /*#__PURE__*/_react.default.createElement(_security_solution_context.SecuritySolutionContext.Provider, {
  value: securitySolutionContext
}, /*#__PURE__*/_react.default.createElement(_use_kibana.KibanaContextProvider, {
  services: services
}, /*#__PURE__*/_react.default.createElement(_enterprise_guard.EnterpriseGuard, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement("div", null)
}, /*#__PURE__*/_react.default.createElement(LazyIndicatorsPageWrapper, null)))))));
exports.createApp = createApp;
class ThreatIntelligencePlugin {
  async setup(core, plugins) {
    const externalAttachmentType = (0, _utils.generateAttachmentType)();
    plugins.cases.attachmentFramework.registerExternalReference(externalAttachmentType);
    return {};
  }
  start(core, plugins) {
    const localPluginServices = {
      storage: new _public.Storage(localStorage)
    };
    const services = {
      ...localPluginServices,
      ...core,
      ...plugins
    };
    return {
      getComponent: createApp(services)
    };
  }
  stop() {}
}
exports.ThreatIntelligencePlugin = ThreatIntelligencePlugin;