"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilters = void 0;
var _react = require("react");
var _indicators = require("../../indicators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Custom react hook housing logic for KQL bar
 * @returns Filters and TimeRange for use with KQL bar
 */
const useFilters = () => {
  const contextValue = (0, _react.useContext)(_indicators.IndicatorsFiltersContext);
  if (!contextValue) {
    throw new Error('Filters can only be used inside IndicatorFiltersContext');
  }
  return contextValue;
};
exports.useFilters = useFilters;