"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilterInOut = void 0;
var _react = require("react");
var _indicators = require("../../indicators");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Custom hook that uses an indicator, a field and a type (FilterIn or FilterOut) and returns the filter function.
 *
 */
const useFilterInOut = ({
  indicator,
  field,
  filterType
}) => {
  const {
    filterManager
  } = (0, _indicators.useIndicatorsFiltersContext)();
  const {
    key,
    value
  } = typeof indicator === 'string' ? {
    key: field,
    value: indicator
  } : (0, _indicators.getIndicatorFieldAndValue)(indicator, field);
  const filterFn = (0, _react.useCallback)(() => {
    const existingFilters = filterManager.getFilters();
    const newFilters = (0, _utils.updateFiltersArray)(existingFilters, key, value, filterType);
    filterManager.setFilters(newFilters);
  }, [filterManager, filterType, key, value]);
  if (!(0, _indicators.fieldAndValueValid)(key, value)) {
    return {};
  }
  return {
    filterFn
  };
};
exports.useFilterInOut = useFilterInOut;