"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterInContextMenu = exports.FilterInCellAction = exports.FilterInButtonIcon = exports.FilterInButtonEmpty = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("../../hooks");
var _utils = require("../../utils");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ICON_TYPE = 'plusInCircle';
/**
 * Retrieves the indicator's field and value, then creates a new {@link Filter} and adds it to the {@link FilterManager}.
 *
 * This component renders an {@link EuiButtonIcon}.
 *
 * @returns filter in button icon
 */
const FilterInButtonIcon = ({
  data,
  field,
  'data-test-subj': dataTestSub
}) => {
  const {
    filterFn
  } = (0, _hooks.useFilterInOut)({
    indicator: data,
    field,
    filterType: _utils.FilterIn
  });
  if (!filterFn) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translations.TITLE,
    iconType: ICON_TYPE,
    iconSize: "s",
    size: "xs",
    color: "primary",
    onClick: filterFn,
    "data-test-subj": dataTestSub
  }));
};

/**
 * Retrieves the indicator's field and value, then creates a new {@link Filter} and adds it to the {@link FilterManager}.
 *
 * This component renders an {@link EuiButtonEmpty}.
 *
 * @returns filter in button empty
 */
exports.FilterInButtonIcon = FilterInButtonIcon;
const FilterInButtonEmpty = ({
  data,
  field,
  'data-test-subj': dataTestSub
}) => {
  const {
    filterFn
  } = (0, _hooks.useFilterInOut)({
    indicator: data,
    field,
    filterType: _utils.FilterIn
  });
  if (!filterFn) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _translations.TITLE,
    iconType: ICON_TYPE,
    iconSize: "s",
    color: "primary",
    onClick: filterFn,
    "data-test-subj": dataTestSub
  }, _translations.TITLE));
};

/**
 * Retrieves the indicator's field and value, then creates a new {@link Filter} and adds it to the {@link FilterManager}.
 *
 * This component is to be used in an EuiContextMenu.
 *
 * @returns filter in {@link EuiContextMenuItem} for a context menu
 */
exports.FilterInButtonEmpty = FilterInButtonEmpty;
const FilterInContextMenu = ({
  data,
  field,
  'data-test-subj': dataTestSub
}) => {
  const {
    filterFn
  } = (0, _hooks.useFilterInOut)({
    indicator: data,
    field,
    filterType: _utils.FilterIn
  });
  if (!filterFn) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "filterIn",
    icon: "plusInCircle",
    size: "s",
    onClick: filterFn,
    "data-test-subj": dataTestSub
  }, _translations.TITLE);
};

/**
 * Retrieves the indicator's field and value, then creates a new {@link Filter} and adds it to the {@link FilterManager}.
 *
 * This component is to be used in an EuiDataGrid.
 *
 * @returns filter in button for data grid
 */
exports.FilterInContextMenu = FilterInContextMenu;
const FilterInCellAction = ({
  data,
  field,
  Component,
  'data-test-subj': dataTestSub
}) => {
  const {
    filterFn
  } = (0, _hooks.useFilterInOut)({
    indicator: data,
    field,
    filterType: _utils.FilterIn
  });
  if (!filterFn) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": dataTestSub
  }, /*#__PURE__*/_react.default.createElement(Component, {
    "aria-label": _translations.TITLE,
    iconType: ICON_TYPE,
    onClick: filterFn
  }, _translations.TITLE)));
};
exports.FilterInCellAction = FilterInCellAction;