"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFetchAggregatedIndicators = exports.convertAggregationToChartSeries = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../../../common/constants");
var _indicator = require("../../../../common/types/indicator");
var _dates = require("../../../common/utils/dates");
var _search = require("../../../utils/search");
var _get_indicator_query_params = require("../utils/get_indicator_query_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIMESTAMP_FIELD = _indicator.RawIndicatorFieldId.TimeStamp;
/**
 * Converts data received from an Elastic search with date_histogram aggregation enabled to something usable in the "@elastic/chart" BarChart component
 * @param aggregations An array of {@link Aggregation} objects to process
 * @param userTimeZone User's timezone as a string
 * @param userFormat User's time format as a string
 * @param field Field Eui combobox options
 * @returns An array of  {@link ChartSeries} directly usable in a BarChart component
 */
const convertAggregationToChartSeries = (aggregations, userTimeZone, userFormat, field) => aggregations.reduce((accumulated, current) => accumulated.concat(current.events.buckets.map(val => ({
  x: val.key_as_string,
  y: val.doc_count,
  g: field.value === 'date' ? (0, _dates.dateFormatter)((0, _moment.default)(current.key), userTimeZone, userFormat) : current.key
}))), []);
exports.convertAggregationToChartSeries = convertAggregationToChartSeries;
const createFetchAggregatedIndicators = ({
  inspectorAdapter,
  searchService,
  queryService,
  userTimeZone,
  userFormat
}) => async ({
  selectedPatterns,
  timeRange,
  field,
  filterQuery,
  filters
}, signal) => {
  const dateRange = queryService.timefilter.timefilter.calculateBounds(timeRange);
  const dateFrom = dateRange.min.toDate().getTime();
  const dateTo = dateRange.max.toDate().getTime();
  const sharedParams = (0, _get_indicator_query_params.getIndicatorQueryParams)({
    timeRange,
    filters,
    filterQuery
  });
  const searchRequestBody = {
    fields: [TIMESTAMP_FIELD, field.label],
    size: 0,
    ...sharedParams
  };
  const {
    aggregations: {
      [_constants.BARCHART_AGGREGATION_NAME]: aggregation
    }
  } = await (0, _search.search)(searchService, {
    params: {
      index: selectedPatterns,
      body: searchRequestBody
    },
    factoryQueryType: _constants.FactoryQueryType.Barchart,
    dateRange: {
      from: dateFrom,
      to: dateTo
    },
    field: field.label
  }, {
    signal,
    inspectorAdapter,
    requestName: 'Indicators barchart'
  });
  const aggregations = aggregation === null || aggregation === void 0 ? void 0 : aggregation.buckets;
  const chartSeries = convertAggregationToChartSeries(aggregations, userTimeZone, userFormat, field);
  return chartSeries;
};
exports.createFetchAggregatedIndicators = createFetchAggregatedIndicators;