"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_block_list_context = require("../hooks/use_block_list_context");
var _block_list_provider = require("../containers/block_list_provider");
var _flyout = require("../../block_list/containers/flyout");
var _barchart = require("../components/barchart");
var _table = require("../components/table");
var _hooks = require("../hooks");
var _layout = require("../../../components/layout");
var _query_bar = require("../../query_bar");
var _filters_global = require("../../../containers/filters_global");
var _field_types_provider = require("../../../containers/field_types_provider");
var _inspector = require("../../../containers/inspector");
var _hooks2 = require("../components/table/hooks");
var _filters = require("../containers/filters");
var _update_status = require("../../../components/update_status");
var _query_bar2 = require("../../query_bar/query_bar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicatorsPageProviders = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_filters.IndicatorsFilters, null, /*#__PURE__*/_react.default.createElement(_field_types_provider.FieldTypesProvider, null, /*#__PURE__*/_react.default.createElement(_inspector.InspectorProvider, null, /*#__PURE__*/_react.default.createElement(_block_list_provider.BlockListProvider, null, children))));
const IndicatorsPageContent = () => {
  const {
    blockListIndicatorValue
  } = (0, _use_block_list_context.useBlockListContext)();
  const {
    browserFields,
    indexPattern
  } = (0, _hooks.useSourcererDataView)();
  const columnSettings = (0, _hooks2.useColumnSettings)();
  const {
    timeRange,
    filters,
    filterQuery
  } = (0, _query_bar.useFilters)();
  const {
    indicatorCount,
    indicators,
    onChangeItemsPerPage,
    onChangePage,
    pagination,
    isLoading: isLoadingIndicators,
    isFetching: isFetchingIndicators,
    dataUpdatedAt,
    query: indicatorListQuery
  } = (0, _hooks.useIndicators)({
    filters,
    filterQuery,
    timeRange,
    sorting: columnSettings.sorting.columns
  });
  const {
    dateRange,
    series,
    selectedField,
    onFieldChange,
    isLoading: isLoadingAggregatedIndicators,
    isFetching: isFetchingAggregatedIndicators,
    query: indicatorChartQuery
  } = (0, _hooks.useAggregatedIndicators)({
    timeRange,
    filters,
    filterQuery
  });
  return /*#__PURE__*/_react.default.createElement(_field_types_provider.FieldTypesProvider, null, /*#__PURE__*/_react.default.createElement(_layout.DefaultPageLayout, {
    pageTitle: "Indicators",
    subHeader: /*#__PURE__*/_react.default.createElement(_update_status.UpdateStatus, {
      isUpdating: isFetchingIndicators,
      updatedAt: dataUpdatedAt
    })
  }, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_query_bar2.QueryBar, {
    queries: [indicatorChartQuery, indicatorListQuery],
    indexPattern: indexPattern
  })), /*#__PURE__*/_react.default.createElement(_barchart.IndicatorsBarChartWrapper, {
    dateRange: dateRange,
    series: series,
    timeRange: timeRange,
    indexPattern: indexPattern,
    field: selectedField,
    onFieldChange: onFieldChange,
    isFetching: isFetchingAggregatedIndicators,
    isLoading: isLoadingAggregatedIndicators
  }), /*#__PURE__*/_react.default.createElement(_table.IndicatorsTable, {
    browserFields: browserFields,
    indexPattern: indexPattern,
    columnSettings: columnSettings,
    pagination: pagination,
    indicatorCount: indicatorCount,
    indicators: indicators,
    isLoading: isLoadingIndicators,
    isFetching: isFetchingIndicators,
    onChangeItemsPerPage: onChangeItemsPerPage,
    onChangePage: onChangePage
  }), blockListIndicatorValue && /*#__PURE__*/_react.default.createElement(_flyout.BlockListFlyout, {
    indicatorFileHash: blockListIndicatorValue
  })));
};
const IndicatorsPage = () => /*#__PURE__*/_react.default.createElement(IndicatorsPageProviders, null, /*#__PURE__*/_react.default.createElement(IndicatorsPageContent, null));
exports.IndicatorsPage = IndicatorsPage;