"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicatorsTotalCount = void 0;
var _react = require("react");
var _common = require("@kbn/data-plugin/common");
var _hooks = require("../../../hooks");
var _use_sourcerer_data_view = require("./use_sourcerer_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIndicatorsTotalCount = () => {
  const {
    services: {
      data: {
        search: searchService
      }
    }
  } = (0, _hooks.useKibana)();
  const [count, setCount] = (0, _react.useState)(0);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const {
    selectedPatterns,
    loading: loadingDataView
  } = (0, _use_sourcerer_data_view.useSourcererDataView)();
  (0, _react.useEffect)(() => {
    const query = {
      bool: {
        must: [{
          term: {
            'event.category': {
              value: 'threat'
            }
          }
        }, {
          term: {
            'event.type': {
              value: 'indicator'
            }
          }
        }]
      }
    };
    const req = {
      params: {
        index: selectedPatterns,
        body: {
          size: 0,
          query
        }
      }
    };
    searchService.search(req).subscribe({
      next: res => {
        if ((0, _common.isCompleteResponse)(res)) {
          const returnedCount = res.rawResponse.hits.total || 0;
          setCount(returnedCount);
          setIsLoading(false);
        }
      }
    });
  }, [searchService, selectedPatterns]);
  return {
    count,
    isLoading: isLoading || loadingDataView
  };
};
exports.useIndicatorsTotalCount = useIndicatorsTotalCount;