"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenIndicatorFlyoutButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Button added to the actions column of the indicators table to open/close the IndicatorFlyout component.
 */
const OpenIndicatorFlyoutButton = ({
  indicator,
  onOpen,
  isOpen
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.BUTTON_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": _test_ids.BUTTON_TEST_ID,
    color: isOpen ? 'text' : 'primary',
    iconType: isOpen ? 'minimize' : 'expand',
    isSelected: isOpen,
    iconSize: "s",
    "aria-label": _translations.BUTTON_LABEL,
    onClick: () => onOpen(indicator)
  }));
};
exports.OpenIndicatorFlyoutButton = OpenIndicatorFlyoutButton;