"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cellRendererFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _styles = require("./styles");
var _hooks = require("../../../../../hooks");
var _field_value = require("../../field_value");
var _contexts = require("../contexts");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cellRendererFactory = from => {
  return ({
    rowIndex,
    columnId,
    setCellProps
  }) => {
    const styles = (0, _styles.useStyles)();
    const indicatorsTableContext = (0, _react.useContext)(_contexts.IndicatorsTableContext);
    if (!indicatorsTableContext) {
      throw new Error('this can only be used inside indicators table');
    }
    const {
      services: {
        uiSettings
      }
    } = (0, _hooks.useKibana)();
    const darkMode = uiSettings.get('theme:darkMode');
    const {
      indicators,
      expanded
    } = indicatorsTableContext;
    const indicator = indicators[rowIndex - from];
    (0, _react.useEffect)(() => {
      if (expanded && indicator && expanded._id === indicator._id) {
        setCellProps({
          style: {
            backgroundColor: darkMode ? _uiTheme.euiDarkVars.euiColorHighlight : _uiTheme.euiLightVars.euiColorHighlight
          }
        });
      } else {
        setCellProps({
          style: undefined
        });
      }
    }, [darkMode, expanded, indicator, setCellProps]);
    if (!indicator) {
      return null;
    }
    const renderContent = columnId === 'Actions' ? /*#__PURE__*/_react.default.createElement(_.ActionsRowCell, {
      indicator: indicator
    }) : /*#__PURE__*/_react.default.createElement(_field_value.IndicatorFieldValue, {
      indicator: indicator,
      field: columnId
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      css: styles.tableCell
    }, renderContent);
  };
};
exports.cellRendererFactory = cellRendererFactory;