"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cellPopoverRendererFactory = exports.CELL_POPOVER_TIMELINE_BUTTON_TEST_ID = exports.CELL_POPOVER_FILTER_OUT_BUTTON_TEST_ID = exports.CELL_POPOVER_FILTER_IN_BUTTON_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _copy_to_clipboard = require("../../copy_to_clipboard/copy_to_clipboard");
var _query_bar = require("../../../../query_bar");
var _timeline = require("../../../../timeline");
var _field_value = require("../../../utils/field_value");
var _styles = require("./styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CELL_POPOVER_TIMELINE_BUTTON_TEST_ID = 'tiIndicatorsTableCellPopoverTimelineButton';
exports.CELL_POPOVER_TIMELINE_BUTTON_TEST_ID = CELL_POPOVER_TIMELINE_BUTTON_TEST_ID;
const CELL_POPOVER_FILTER_IN_BUTTON_TEST_ID = 'tiIndicatorsTableCellPopoverFilterInButton';
exports.CELL_POPOVER_FILTER_IN_BUTTON_TEST_ID = CELL_POPOVER_FILTER_IN_BUTTON_TEST_ID;
const CELL_POPOVER_FILTER_OUT_BUTTON_TEST_ID = 'tiIndicatorsTableCellPopoverFilterOutButton';

/**
 * Used for the Indicators table cellActions column property.
 *
 * @param indicators array of {@link Indicator}
 * @param pagination information about table current page
 */
exports.CELL_POPOVER_FILTER_OUT_BUTTON_TEST_ID = CELL_POPOVER_FILTER_OUT_BUTTON_TEST_ID;
const cellPopoverRendererFactory = (indicators, pagination) => props => {
  const styles = (0, _styles.useStyles)();
  const {
    rowIndex,
    columnId
  } = props;
  const indicator = indicators[rowIndex % pagination.pageSize];
  const {
    key,
    value
  } = (0, _field_value.getIndicatorFieldAndValue)(indicator, columnId);
  if (!(0, _field_value.fieldAndValueValid)(key, value)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "m",
    css: styles.popoverMaxWidth
  }, value), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_bar.FilterInButtonEmpty, {
    data: indicator,
    field: key,
    "data-test-subj": CELL_POPOVER_TIMELINE_BUTTON_TEST_ID
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_bar.FilterOutButtonEmpty, {
    data: indicator,
    field: key,
    "data-test-subj": CELL_POPOVER_FILTER_IN_BUTTON_TEST_ID
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_timeline.AddToTimelineButtonEmpty, {
    data: indicator,
    field: key,
    "data-test-subj": CELL_POPOVER_FILTER_OUT_BUTTON_TEST_ID
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_copy_to_clipboard.CopyToClipboardButtonEmpty, {
    value: value
  }))));
};
exports.cellPopoverRendererFactory = cellPopoverRendererFactory;