"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CellActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _timeline = require("../../../../timeline");
var _query_bar = require("../../../../query_bar");
var _utils = require("../../../utils");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component used on an EuiDataGrid component (in our case for our IndicatorsTable component),
 * added to the cellActions property of an EuiDataGridColumn.
 * It displays the FilterIn, FilterOut and AddToTimeline icons in the popover
 * when the user hovers above a cell.
 */
const CellActions = ({
  rowIndex,
  columnId,
  Component,
  indicators,
  pagination
}) => {
  const indicator = indicators[rowIndex % pagination.pageSize];
  const {
    key,
    value
  } = (0, _utils.getIndicatorFieldAndValue)(indicator, columnId);
  if (!(0, _utils.fieldAndValueValid)(key, value)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_query_bar.FilterInCellAction, {
    data: indicator,
    field: key,
    Component: Component,
    "data-test-subj": _test_ids.FILTER_IN_BUTTON_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_query_bar.FilterOutCellAction, {
    data: indicator,
    field: key,
    Component: Component,
    "data-test-subj": _test_ids.FILTER_OUT_BUTTON_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_timeline.AddToTimelineCellAction, {
    data: indicator,
    field: key,
    Component: Component,
    "data-test-subj": _test_ids.TIMELINE_BUTTON_TEST_ID
  }));
};
exports.CellActions = CellActions;