"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsRowCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _more_actions = require("./more_actions/more_actions");
var _timeline = require("../../../../timeline");
var _open_flyout_button = require("./open_flyout_button");
var _contexts = require("../contexts");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionsRowCell = ({
  indicator
}) => {
  const indicatorTableContext = (0, _react.useContext)(_contexts.IndicatorsTableContext);
  if (!indicatorTableContext) {
    throw new Error(`indicatorTableContext has to be defined`);
  }
  const {
    setExpanded,
    expanded
  } = indicatorTableContext;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_open_flyout_button.OpenIndicatorFlyoutButton, {
    indicator: indicator,
    onOpen: setExpanded,
    isOpen: Boolean(expanded && expanded._id === indicator._id)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_timeline.InvestigateInTimelineButtonIcon, {
    data: indicator,
    "data-test-subj": _test_ids.INVESTIGATE_IN_TIMELINE_TEST_ID
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_more_actions.MoreActions, {
    indicator: indicator
  })));
};
exports.ActionsRowCell = ActionsRowCell;