"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicatorsFlyoutContext = void 0;
var _react = require("react");
var _context = require("./context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to retrieve {@link IndicatorsFiltersContext} (contains FilterManager)
 */
const useIndicatorsFlyoutContext = () => {
  const contextValue = (0, _react.useContext)(_context.IndicatorsFlyoutContext);
  if (!contextValue) {
    throw new Error('IndicatorsFlyoutContext can only be used within IndicatorsFlyoutContext provider');
  }
  return contextValue;
};
exports.useIndicatorsFlyoutContext = useIndicatorsFlyoutContext;